package agrigolo.chubbyclick.metronome;

import android.content.Context;
import android.os.AsyncTask;

import androidx.core.app.NotificationCompat;
import androidx.core.app.NotificationManagerCompat;

import agrigolo.chubbyclick.Application;
import agrigolo.chubbyclick.R;


public class MetronomeManager extends AsyncTask<Void, Integer, String> {

    private Metronome metronome;
    private NotificationCompat.Builder builder;
    private NotificationManagerCompat notificationManager;
    private Context metronomeContext = Application.getContext();

    public MetronomeManager(double bpm, int beat) {

        metronome = new Metronome(bpm, beat);

        builder = new NotificationCompat.Builder(metronomeContext, "CHUBBYCLICK")
                .setSmallIcon(R.drawable.ic_launcher_foreground)
                .setContentTitle("Chubby Click")
                .setPriority(NotificationCompat.PRIORITY_LOW);

        notificationManager = NotificationManagerCompat.from(metronomeContext);
    }

    @Override
    protected String doInBackground(Void... arg0) {
        showRunningNotification();
        metronome.play();
        return null;
    }

    public void stop() {
        hideRunningNotification();
        metronome.stop();
    }

    public boolean isPlaying() {
        return metronome.isPlaying();
    }

    public void setBpm(double bpm) {
        metronome.setBpm(bpm);
    }

    public void setBeat(int beat) {
        metronome.setBeat(beat);
    }

    public void playSample(int freq, int duration) {
        metronome.playSample(freq, duration);
    }

    private void showRunningNotification() {

        int bpm = metronome.getBpm().intValue();

        String contentText = "Metronome is running - "
                + bpm + " BPM, "
                + metronome.getBeat() + " Beats";

        notificationManager.notify(1,
                builder.setContentText(contentText)
                        .build()
        );

    }

    private void hideRunningNotification() {
        notificationManager.cancel(1);
    }


}
