package agrigolo.chubbyclick.utilities;

import android.content.Context;
import android.content.SharedPreferences;

import agrigolo.chubbyclick.Application;

public class Preferences {

    private static String PREF_NAME = "prefs";
    //DEFAULT VALUES :
    private final static String defaultBpm = "100";
    private final static String defaultBeat = "4";
    private final static String defaultNoteDuration = "600";
    private final static String defaultAccentPitch = "650";
    private final static String defaultBeatPitch = "440";
    private static Context prefsContext = Application.getContext();

    private static SharedPreferences getPrefs() {
        return prefsContext.getSharedPreferences(PREF_NAME, Context.MODE_PRIVATE);
    }

    public static String getBpm() {
        return getPrefs().getString("bpm", defaultBpm);
    }

    public static void setBpm(String input) {
        SharedPreferences.Editor editor = getPrefs().edit();
        editor.putString("bpm", input);
        editor.commit();
    }

    public static String getBeat() {
        return getPrefs().getString("beat", defaultBeat);
    }

    public void setBeat(String input) {
        SharedPreferences.Editor editor = getPrefs().edit();
        editor.putString("beat", input);
        editor.commit();
    }

    public String getNoteDuration() {
        return getPrefs().getString("noteDuration", defaultNoteDuration);
    }

    public void setNoteDuration(String input) {
        SharedPreferences.Editor editor = getPrefs().edit();
        editor.putString("noteDuration", input);
        editor.commit();
    }

    public String getAccentPitch() {
        return getPrefs().getString("highTickFreq", defaultAccentPitch);
    }

    public void setAccentPitch(String input) {
        SharedPreferences.Editor editor = getPrefs().edit();
        editor.putString("highTickFreq", input);
        editor.commit();
    }

    public String getBeatPitch() {
        return getPrefs().getString("lowTickFreq", defaultBeatPitch);
    }

    public void getBeatPitch(String input) {
        SharedPreferences.Editor editor = getPrefs().edit();
        editor.putString("lowTickFreq", input);
        editor.commit();
    }


    public String getDefaultNoteDuration() {
        return defaultNoteDuration;
    }

    public String getDefaultAccentPitch() {
        return defaultAccentPitch;
    }

    public String getDefaultBeatPitch() {
        return defaultBeatPitch;
    }

}