package agrigolo.chubbyclick.metronome;

import agrigolo.chubbyclick.utilities.Preferences;

public class Metronome {

    private double bpm;
    private int beat;
    private int silence;
    private int sampleRate = 8000;
    private int tick;
    private int accentPitch;
    private int beatPitch;
    private Preferences prefs = new Preferences();
    private boolean play = false;

    private AudioGenerator audioGenerator = new AudioGenerator(sampleRate);

    Metronome(double bpm, int beat) {

        audioGenerator.createPlayer();
        this.bpm = bpm;
        this.beat = beat;
        this.beatPitch = Integer.valueOf(prefs.getBeatPitch());
        this.accentPitch = Integer.valueOf(prefs.getAccentPitch());
        this.tick = Integer.valueOf(prefs.getNoteDuration());

    }

    private void calcSilence() {
        silence = (int) (((60 / bpm) * sampleRate) - tick);
    }

    void play() {

        this.play = true;
        double[] highTick =
                audioGenerator.getSineWave(this.tick, sampleRate, accentPitch);
        double[] lowTick =
                audioGenerator.getSineWave(this.tick, sampleRate, beatPitch);
        if (beat == 0) {
            highTick = lowTick;
        }
        double silence = 0;
        double[] sound = new double[sampleRate];
        int t = 0, s = 0, b = 0;
        do {
            //Calculate silence duration in every cycle to change the bpm without restarting the task
            calcSilence();
            for (int i = 0; i < sound.length && play; i++) {
                if (t < this.tick) {
                    if (b == 0)
                        sound[i] = highTick[t];
                    else
                        sound[i] = lowTick[t];
                    t++;
                } else {
                    sound[i] = silence;
                    s++;
                    if (s >= this.silence) {
                        t = 0;
                        s = 0;
                        b++;
                        if (b > (this.beat - 1))
                            b = 0;
                    }
                }
            }
            audioGenerator.writeSound(sound);
        } while (this.play);
    }

    void stop() {
        this.play = false;
        audioGenerator.destroyAudioTrack();
    }

    void playSample(int freq, int duration) {

        double[] tick =
                audioGenerator.getSineWave(duration, sampleRate, freq);

        double[] sound = new double[sampleRate];
        int t = 0, s = 0, b = 0;

        for (int i = 0; i < sound.length; i++) {
            if (t < duration) {
                sound[i] = tick[t];
                t++;
            }
        }
        audioGenerator.writeSound(sound);
    }

    /* Getters and Setters*/

    boolean isPlaying() {
        return this.play;
    }

    void setBpm(double new_bpm) {
        bpm = new_bpm;
    }

    void setBeat(int new_beat) {
        beat = new_beat;
    }

}