package agrigolo.chubbyclick;

import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.pm.ActivityInfo;
import android.os.Build;
import android.os.Bundle;
import android.text.Editable;
import android.text.TextWatcher;
import android.view.View;
import android.view.WindowManager;
import android.widget.Button;
import android.widget.EditText;
import android.widget.ImageButton;
import android.widget.SeekBar;
import android.widget.TextView;

import androidx.appcompat.app.AlertDialog;
import androidx.appcompat.app.AppCompatActivity;

import com.google.android.material.snackbar.Snackbar;

import agrigolo.chubbyclick.metronome.MetronomeManager;
import agrigolo.chubbyclick.setlist.SetlistActivity;
import agrigolo.chubbyclick.utilities.Preferences;
import agrigolo.chubbyclick.utilities.TapTempo;

import static java.lang.Double.valueOf;

public class MainActivity extends AppCompatActivity {

    private boolean soundDialogOpened = false;
    private Preferences prefs;
    double current_bpm;
    int current_beat;
    Context myContext = this;

    TapTempo taptempo = new TapTempo();

    private MetronomeManager metronome;
    private soundSettingsDialog soundDialog = new soundSettingsDialog();

    @Override
    protected void onCreate(Bundle savedInstanceState) {

        prefs = new Preferences();

        current_beat = Integer.parseInt(prefs.getBeat());
        current_bpm = Double.parseDouble(prefs.getBpm());

        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.O) {
            CharSequence name = getString(R.string.channel_name);
            String description = getString(R.string.channel_description);
            int importance = NotificationManager.IMPORTANCE_LOW;
            NotificationChannel channel = new NotificationChannel("CHUBBYCLICK", name, importance);
            channel.setDescription(description);
            NotificationManager notificationManager = getSystemService(NotificationManager.class);
            notificationManager.createNotificationChannel(channel);
        }

        metronome = new MetronomeManager(current_bpm, current_beat);

        super.onCreate(savedInstanceState);
        getWindow().addFlags(WindowManager.LayoutParams.FLAG_KEEP_SCREEN_ON);
        setContentView(R.layout.activity_main);
        setRequestedOrientation(ActivityInfo.SCREEN_ORIENTATION_PORTRAIT);

        final SeekBar seekbar = findViewById(R.id.tempo_seek);
        final TextView bpmText = findViewById(R.id.bpm_text);
        final EditText beatText = findViewById(R.id.input_beats);
        beatText.setText(String.valueOf(current_beat));

        seekbar.setProgress((int) current_bpm);
        bpmText.setText(String.valueOf((int) current_bpm));

        final ImageButton aboutButton = findViewById(R.id.aboutButton);
        final ImageButton settingsButton = findViewById(R.id.settingsButton);

        final Button startButton = findViewById(R.id.start_stop);
        final Button tapTempoButton = findViewById(R.id.tap_tempo);
        final Button minusOneButton = findViewById(R.id.minus_1);
        final Button minusTenButton = findViewById(R.id.minus_10);
        final Button plusOneButton = findViewById(R.id.plus_1);
        final Button plusTenButton = findViewById(R.id.plus_10);
        final Button beatPlusButton = findViewById(R.id.beat_plus);
        final Button beatMinusButton = findViewById(R.id.beat_minus);
        final Button setListButton = findViewById(R.id.setlist_button);

        aboutButton.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                aboutDialog();
            }
        });

        settingsButton.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                if(metronome.isPlaying()) {
                    metronome.stop();
                    metronome = new MetronomeManager(current_bpm, current_beat);
                    startButton.setText(getResources().getString(R.string.text_start));
                }
                soundDialogOpened=true;
                soundDialog.showDialog(current_bpm, current_beat, myContext);
            }
        });

        tapTempoButton.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                if (!taptempo.tap()) {
                    Snackbar.make(v, getResources().getString(R.string.taptempo_reset), 4000).show();
                }
                current_bpm = taptempo.getAvgBpm();
                change_bpm(current_bpm);
            }
        });
        minusOneButton.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                if (current_bpm > 1) {
                    current_bpm -= 1;
                    change_bpm(current_bpm);
                }
            }
        });
        minusTenButton.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                if (current_bpm > 10) {
                    current_bpm -= 10;
                    change_bpm(current_bpm);
                }
            }
        });
        plusOneButton.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                if (current_bpm < 400) {
                    current_bpm += 1;
                    change_bpm(current_bpm);
                }
            }
        });
        plusTenButton.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                if (current_bpm <= 390) {
                    current_bpm += 10;
                    change_bpm(current_bpm);
                }
            }
        });
        beatMinusButton.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                if (current_beat > 1) {
                    current_beat -= 1;
                    beatText.setText(String.valueOf(current_beat));
                    prefs.setBeat(String.valueOf(current_beat));
                    if (metronome.isPlaying()) {
                        restartClick();
                    } else {
                        metronome = new MetronomeManager(current_bpm, current_beat);
                    }
                }
            }
        });

        beatPlusButton.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                if (current_beat < 32) {
                    current_beat += 1;
                    beatText.setText(String.valueOf(current_beat));
                    prefs.setBeat(String.valueOf(current_beat));
                    if (metronome.isPlaying()) {
                        restartClick();
                    } else {
                        metronome = new MetronomeManager(current_bpm, current_beat);
                    }
                }
            }
        });

        beatText.addTextChangedListener(new TextWatcher() {

            public void afterTextChanged(Editable s) {
                current_beat = Integer.parseInt(beatText.getText().toString());
                metronome.setBeat(current_beat);
                prefs.setBeat(String.valueOf(current_beat));

            }

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            }

            public void onTextChanged(CharSequence s, int start, int before, int count) {
            }
        });


        startButton.setOnClickListener(new View.OnClickListener() {

            @Override
            public void onClick(View v) {
                if(soundDialogOpened==true) {
                    metronome = new MetronomeManager(current_bpm, current_beat);
                    soundDialogOpened=false;
                }
                if (!metronome.isPlaying()) {
                    metronome.execute();
                    startButton.setText(getResources().getString(R.string.text_stop));
                } else {
                    metronome.stop();
                    metronome = new MetronomeManager(current_bpm, current_beat);
                    startButton.setText(getResources().getString(R.string.text_start));
                }
            }
        });

        setListButton.setOnClickListener(new View.OnClickListener() {

            @Override
            public void onClick(View v) {
                if (metronome.isPlaying()) {
                    metronome.stop();
                    metronome = new MetronomeManager(current_bpm, current_beat);
                    startButton.setText(getResources().getString(R.string.text_start));
                }
                Intent setListIntent = new Intent(MainActivity.this, SetlistActivity.class);
                MainActivity.this.startActivity(setListIntent);
            }
        });

        seekbar.setOnSeekBarChangeListener(new SeekBar.OnSeekBarChangeListener() {
            @Override
            public void onProgressChanged(SeekBar seekBar, int i, boolean b) {
                bpmText.setText("" + i);
                current_bpm = valueOf(seekBar.getProgress());
                metronome.setBpm(current_bpm);
                prefs.setBpm(String.valueOf(current_bpm));

            }

            @Override
            public void onStartTrackingTouch(SeekBar seekBar) {
            }

            @Override
            public void onStopTrackingTouch(SeekBar seekBar) {
            }

        });

    }

    private void restartClick() {
        metronome.stop();
        metronome = new MetronomeManager(current_bpm, current_beat);
        metronome.execute();
    }


    private void change_bpm(double bpm) {
        SeekBar seekbar = findViewById(R.id.tempo_seek);
        TextView bpmText = findViewById(R.id.bpm_text);
        bpmText.setText("" + bpm);
        metronome.setBpm(bpm);
        seekbar.setProgress((int) bpm);
        prefs.setBpm(String.valueOf(bpm));
    }

    private void aboutDialog() {
        AlertDialog.Builder dialog = new AlertDialog.Builder(this);
        dialog.setMessage(getResources().getString(R.string.about_message));
        dialog.setTitle("Chubby Click " + BuildConfig.VERSION_NAME);
        dialog.setPositiveButton("Ok",
                new DialogInterface.OnClickListener() {
                    public void onClick(DialogInterface dialog,
                                        int which) {
                    }
                });
        AlertDialog alertDialog = dialog.create();
        alertDialog.show();
    }

}