/*
 * Decompiled with CFR 0.152.
 */
package ch.boye.httpclientandroidlib.impl.conn;

import ch.boye.httpclientandroidlib.annotation.NotThreadSafe;
import ch.boye.httpclientandroidlib.impl.conn.Wire;
import java.io.IOException;
import java.io.OutputStream;

@NotThreadSafe
class LoggingOutputStream
extends OutputStream {
    private final OutputStream out;
    private final Wire wire;

    public LoggingOutputStream(OutputStream out, Wire wire) {
        this.out = out;
        this.wire = wire;
    }

    public void write(int b) throws IOException {
        this.wire.output(b);
    }

    public void write(byte[] b) throws IOException {
        this.wire.output(b);
        this.out.write(b);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        this.wire.output(b, off, len);
        this.out.write(b, off, len);
    }

    public void flush() throws IOException {
        this.out.flush();
    }

    public void close() throws IOException {
        this.out.close();
    }
}

