/*
 *  Copyright (C) 2011 in-somnia
 * 
 *  This file is part of JAAD.
 * 
 *  JAAD is free software; you can redistribute it and/or modify it 
 *  under the terms of the GNU Lesser General Public License as 
 *  published by the Free Software Foundation; either version 3 of the 
 *  License, or (at your option) any later version.
 *
 *  JAAD is distributed in the hope that it will be useful, but WITHOUT 
 *  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY 
 *  or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General 
 *  Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library.
 *  If not, see <http://www.gnu.org/licenses/>.
 */
package net.sourceforge.jaad.aac.ps;

interface PSTables {

	int[] IID_ICC_PAR_TABLE = { 10, 20, 34, 10, 20, 34 };
	int[] IPDOPD_PAR_TABLE = { 5, 11, 17, 5, 11, 17 };
	int[][] ENV_COUNT_TABLE = { { 0, 1, 2, 4 }, { 1, 2, 3, 4 } };
	int[] LOG2_TABLE = { 0, 0, 1, 1, 2 };
	// decorrelation
	int[] K_TO_I_20 = { 1, 0, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 14, 15, 15, 15, 16, 16, 16, 16, 17, 17,
			17, 17, 17, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19,
			19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19 };
	int[] K_TO_I_34 = { 0, 1, 2, 3, 4, 5, 6, 6, 7, 2, 1, 0, 10, 10, 4, 5, 6, 7, 8, 9, 10, 11, 12, 9, 14, 11, 12, 13,
			14, 15, 16, 13, 16, 17, 18, 19, 20, 21, 22, 22, 23, 23, 24, 24, 25, 25, 26, 26, 27, 27, 27, 28, 28, 28, 29,
			29, 29, 30, 30, 30, 31, 31, 31, 31, 32, 32, 32, 32, 33, 33, 33, 33, 33, 33, 33, 33, 33, 33, 33, 33, 33, 33,
			33, 33, 33, 33, 33, 33, 33, 33, 33 };
	float[] FILTER_COEF_A = { 0.65143905753106f, 0.56471812200776f, 0.48954165955695f };
	float[] PD_RE_SMOOTH = { 1.000000000000000000e+000f, 8.996611833572387695e-001f, 6.000000238418579102e-001f,
			6.054889410734176636e-002f, -1.000000000000000000e+000f, 6.054889410734176636e-002f,
			6.000000238418579102e-001f, 8.996611833572387695e-001f, 9.765458106994628906e-001f,
			7.773464918136596680e-001f, 4.072504639625549316e-001f, -9.716906398534774780e-002f,
			-7.463273406028747559e-001f, -2.810846269130706787e-001f, 6.824410557746887207e-001f,
			9.654892683029174805e-001f, 9.284766912460327148e-001f, 6.212936043739318848e-001f,
			1.643989831209182739e-001f, -3.541385531425476074e-001f, -8.320503234863281250e-001f,
			-9.108680486679077148e-001f, 4.472135901451110840e-001f, 9.773793220520019531e-001f,
			9.302640557289123535e-001f, 4.945702850818634033e-001f, -7.628192752599716187e-002f,
			-6.072454452514648438e-001f, -9.523198604583740234e-001f, -9.166177511215209961e-001f,
			-1.581720858812332153e-001f, 8.628562688827514648e-001f, 1.000000000000000000e+000f,
			5.428888201713562012e-001f, -2.425356209278106689e-001f, -8.043046593666076660e-001f,
			-1.000000000000000000e+000f, -8.043046593666076660e-001f, -2.425356209278106689e-001f,
			5.428888201713562012e-001f, 9.302640557289123535e-001f, 8.628562092781066895e-001f,
			-1.581720858812332153e-001f, -9.166177511215209961e-001f, -9.523198604583740234e-001f,
			-6.072454452514648438e-001f, -7.628192752599716187e-002f, 4.945702850818634033e-001f,
			9.284766912460327148e-001f, 9.773793220520019531e-001f, 4.472135901451110840e-001f,
			-9.108680486679077148e-001f, -8.320503234863281250e-001f, -3.541385233402252197e-001f,
			1.643989831209182739e-001f, 6.212936043739318848e-001f, 9.765458106994628906e-001f,
			9.654892683029174805e-001f, 6.824410557746887207e-001f, -2.810846269130706787e-001f,
			-7.463273406028747559e-001f, -9.716906398534774780e-002f, 4.072504639625549316e-001f,
			7.773464918136596680e-001f, 9.944884777069091797e-001f, 8.427693247795104980e-001f,
			4.985431432723999023e-001f, -3.429438173770904541e-002f, -8.773552179336547852e-001f,
			-5.709763988852500916e-002f, 6.350517868995666504e-001f, 9.337818622589111328e-001f,
			9.448713660240173340e-001f, 7.071068286895751953e-001f, 3.274416029453277588e-001f,
			-1.414213627576828003e-001f, -6.629949212074279785e-001f, -7.071067690849304199e-001f,
			7.486239075660705566e-001f, 9.899495244026184082e-001f, 8.668649196624755859e-001f,
			5.382750034332275391e-001f, 1.048454344272613525e-001f, -3.578427135944366455e-001f,
			-7.724695801734924316e-001f, -9.983685612678527832e-001f, 4.798414707183837891e-001f,
			9.994117617607116699e-001f, 8.406600952148437500e-001f, 3.939192891120910645e-001f,
			-1.147523149847984314e-001f, -5.812381505966186523e-001f, -9.116950631141662598e-001f,
			-9.805806875228881836e-001f, -3.522595465183258057e-001f, 9.486832618713378906e-001f,
			9.675381779670715332e-001f, 3.983650505542755127e-001f, -2.648591399192810059e-001f,
			-7.589859366416931152e-001f, -9.911938309669494629e-001f, -8.891312479972839355e-001f,
			-3.654703199863433838e-001f, 5.863608717918395996e-001f, 9.777119159698486328e-001f,
			7.071067690849304199e-001f, -2.099511474370956421e-001f, -8.574929237365722656e-001f,
			-9.889042377471923828e-001f, -7.071067690849304199e-001f, -1.485542953014373779e-001f,
			5.144957304000854492e-001f, 9.642871022224426270e-001f, 9.172270298004150391e-001f,
			2.527247071266174316e-001f, -8.100500106811523438e-001f, -9.308230280876159668e-001f,
			-4.576523900032043457e-001f, 1.324190348386764526e-001f, 6.511070132255554199e-001f,
			9.933940768241882324e-001f, 9.191450476646423340e-001f, 5.415630340576171875e-001f,
			-3.162277638912200928e-001f, -9.359023571014404297e-001f, -1.961161345243453979e-001f,
			4.108675122261047363e-001f, 8.137334585189819336e-001f, 9.863939285278320312e-001f,
			7.835779190063476562e-001f, 3.713906705379486084e-001f, -2.114935219287872314e-001f,
			-8.944271802902221680e-001f, -4.126977622509002686e-001f, 5.547001957893371582e-001f,
			9.351930618286132812e-001f, 9.133164882659912109e-001f, 6.290726661682128906e-001f,
			2.153099924325942993e-001f, -2.604427933692932129e-001f, -7.309406399726867676e-001f,
			-9.596829414367675781e-001f, 6.655790805816650391e-001f, 9.952678680419921875e-001f,
			8.000000119209289551e-001f, 4.365887939929962158e-001f, 0.000000000000000000e+000f,
			-4.365887939929962158e-001f, -8.000000119209289551e-001f, -9.981652498245239258e-001f,
			0.000000000000000000e+000f, 9.981652498245239258e-001f, 7.309406399726867676e-001f,
			2.604427933692932129e-001f, -2.153099924325942993e-001f, -6.290726661682128906e-001f,
			-9.133164882659912109e-001f, -9.952678680419921875e-001f, -6.655790805816650391e-001f,
			9.596829414367675781e-001f, 8.944271802902221680e-001f, 2.114935219287872314e-001f,
			-3.713906705379486084e-001f, -7.835779190063476562e-001f, -9.863939285278320312e-001f,
			-9.351930022239685059e-001f, -5.547001957893371582e-001f, 4.126977622509002686e-001f,
			9.874115586280822754e-001f, 5.054494142532348633e-001f, -3.668907880783081055e-001f,
			-8.691376447677612305e-001f, -9.970862865447998047e-001f, -7.945142388343811035e-001f,
			-3.051016032695770264e-001f, 3.997647166252136230e-001f, 9.701424837112426758e-001f,
			8.398045897483825684e-001f, 0.000000000000000000e+000f, -8.398045897483825684e-001f,
			-9.701424837112426758e-001f, -5.942171812057495117e-001f, 0.000000000000000000e+000f,
			5.942171812057495117e-001f, 9.970862865447998047e-001f, 8.691375851631164551e-001f,
			3.668907880783081055e-001f, -5.054494738578796387e-001f, -9.874115586280822754e-001f,
			-3.997647166252136230e-001f, 3.051016032695770264e-001f, 7.945142388343811035e-001f,
			9.911938309669494629e-001f, 7.589859366416931152e-001f, 2.648591399192810059e-001f,
			-3.983650505542755127e-001f, -9.675381779670715332e-001f, -5.863608717918395996e-001f,
			3.654703199863433838e-001f, 8.891311883926391602e-001f, 9.116950631141662598e-001f,
			5.812381505966186523e-001f, 1.147523149847984314e-001f, -3.939192891120910645e-001f,
			-8.406600952148437500e-001f, -9.486832618713378906e-001f, 3.522595465183258057e-001f,
			9.805806875228881836e-001f, 7.724695801734924316e-001f, 3.578426837921142578e-001f,
			-1.048454344272613525e-001f, -5.382750034332275391e-001f, -8.668649196624755859e-001f,
			-9.994117617607116699e-001f, -4.798414707183837891e-001f, 9.983685612678527832e-001f,
			6.629949212074279785e-001f, 1.414213627576828003e-001f, -3.274416029453277588e-001f,
			-7.071068286895751953e-001f, -9.448713660240173340e-001f, -9.899494647979736328e-001f,
			-7.486239075660705566e-001f, 7.071067690849304199e-001f, 8.773552179336547852e-001f,
			3.429438173770904541e-002f, -4.985431432723999023e-001f, -8.427693247795104980e-001f,
			-9.944884777069091797e-001f, -9.337818622589111328e-001f, -6.350517868995666504e-001f,
			5.709763988852500916e-002f, 9.359023571014404297e-001f, 3.162277638912200928e-001f,
			-5.415630340576171875e-001f, -9.191449880599975586e-001f, -9.933940768241882324e-001f,
			-8.137334585189819336e-001f, -4.108675122261047363e-001f, 1.961161345243453979e-001f,
			9.308230280876159668e-001f, 8.100499510765075684e-001f, -2.527247071266174316e-001f,
			-9.172269701957702637e-001f, -9.642871022224426270e-001f, -6.511070132255554199e-001f,
			-1.324190348386764526e-001f, 4.576523900032043457e-001f, 9.889042377471923828e-001f,
			8.574929833412170410e-001f, 2.099511474370956421e-001f, -7.071067690849304199e-001f,
			-9.777119159698486328e-001f, -5.144957304000854492e-001f, 1.485542953014373779e-001f,
			7.071067690849304199e-001f, 1.000000000000000000e+000f, 8.043046593666076660e-001f,
			2.425356209278106689e-001f, -5.428888201713562012e-001f, -1.000000000000000000e+000f,
			-5.428888201713562012e-001f, 2.425356209278106689e-001f, 8.043046593666076660e-001f,
			9.523198604583740234e-001f, 6.072454452514648438e-001f, 7.628192752599716187e-002f,
			-4.945702552795410156e-001f, -9.302640557289123535e-001f, -8.628562688827514648e-001f,
			1.581720858812332153e-001f, 9.166177511215209961e-001f, 8.320503234863281250e-001f,
			3.541385233402252197e-001f, -1.643989831209182739e-001f, -6.212936043739318848e-001f,
			-9.284766912460327148e-001f, -9.773793220520019531e-001f, -4.472135901451110840e-001f,
			9.108680486679077148e-001f, 7.463273406028747559e-001f, 9.716906398534774780e-002f,
			-4.072504639625549316e-001f, -7.773465514183044434e-001f, -9.765458106994628906e-001f,
			-9.654892683029174805e-001f, -6.824410557746887207e-001f, 2.810846269130706787e-001f,
			1.000000000000000000e+000f, -6.054889410734176636e-002f, -6.000000238418579102e-001f,
			-8.996611237525939941e-001f, -1.000000000000000000e+000f, -8.996611237525939941e-001f,
			-6.000000238418579102e-001f, -6.054889410734176636e-002f, 7.463273406028747559e-001f,
			2.810846269130706787e-001f, -6.824410557746887207e-001f, -9.654892683029174805e-001f,
			-9.765458106994628906e-001f, -7.773465514183044434e-001f, -4.072504639625549316e-001f,
			9.716906398534774780e-002f, 8.320503234863281250e-001f, 9.108680486679077148e-001f,
			-4.472135901451110840e-001f, -9.773793220520019531e-001f, -9.284766912460327148e-001f,
			-6.212936043739318848e-001f, -1.643989831209182739e-001f, 3.541385233402252197e-001f,
			9.523198604583740234e-001f, 9.166177511215209961e-001f, 1.581720858812332153e-001f,
			-8.628561496734619141e-001f, -9.302640557289123535e-001f, -4.945702552795410156e-001f,
			7.628192752599716187e-002f, 6.072454452514648438e-001f, 9.911938309669494629e-001f,
			8.891311883926391602e-001f, 3.654703199863433838e-001f, -5.863608121871948242e-001f,
			-9.675381779670715332e-001f, -3.983650505542755127e-001f, 2.648591399192810059e-001f,
			7.589859366416931152e-001f, 9.889042377471923828e-001f, 7.071067690849304199e-001f,
			1.485542953014373779e-001f, -5.144957304000854492e-001f, -9.777119159698486328e-001f,
			-7.071067690849304199e-001f, 2.099511474370956421e-001f, 8.574929237365722656e-001f,
			9.308230280876159668e-001f, 4.576523900032043457e-001f, -1.324190348386764526e-001f,
			-6.511070132255554199e-001f, -9.642871022224426270e-001f, -9.172269701957702637e-001f,
			-2.527247071266174316e-001f, 8.100498914718627930e-001f, 9.359023571014404297e-001f,
			1.961161345243453979e-001f, -4.108675122261047363e-001f, -8.137334585189819336e-001f,
			-9.933940768241882324e-001f, -9.191449880599975586e-001f, -5.415630340576171875e-001f,
			3.162277638912200928e-001f, 8.773552179336547852e-001f, 5.709763988852500916e-002f,
			-6.350517868995666504e-001f, -9.337818622589111328e-001f, -9.944884777069091797e-001f,
			-8.427693247795104980e-001f, -4.985431432723999023e-001f, 3.429438173770904541e-002f,
			6.629949212074279785e-001f, 7.071067690849304199e-001f, -7.486239075660705566e-001f,
			-9.899494647979736328e-001f, -9.448713660240173340e-001f, -7.071068286895751953e-001f,
			-3.274416029453277588e-001f, 1.414213627576828003e-001f, 7.724695801734924316e-001f,
			9.983685612678527832e-001f, -4.798414707183837891e-001f, -9.994117617607116699e-001f,
			-8.668649196624755859e-001f, -5.382750034332275391e-001f, -1.048454344272613525e-001f,
			3.578426837921142578e-001f, 9.116950631141662598e-001f, 9.805806875228881836e-001f,
			3.522595465183258057e-001f, -9.486832618713378906e-001f, -8.406600952148437500e-001f,
			-3.939192891120910645e-001f, 1.147523149847984314e-001f, 5.812381505966186523e-001f,
			9.863939285278320312e-001f, 9.351930022239685059e-001f, 5.547001957893371582e-001f,
			-4.126977622509002686e-001f, -8.944271802902221680e-001f, -2.114935219287872314e-001f,
			3.713906705379486084e-001f, 7.835779190063476562e-001f, 9.970862865447998047e-001f,
			7.945142388343811035e-001f, 3.051016032695770264e-001f, -3.997647166252136230e-001f,
			-9.874115586280822754e-001f, -5.054494142532348633e-001f, 3.668907880783081055e-001f,
			8.691375851631164551e-001f, 9.701424837112426758e-001f, 5.942171812057495117e-001f,
			0.000000000000000000e+000f, -5.942171812057495117e-001f, -9.701424837112426758e-001f,
			-8.398045897483825684e-001f, 0.000000000000000000e+000f, 8.398045897483825684e-001f,
			9.874115586280822754e-001f, 3.997647166252136230e-001f, -3.051016032695770264e-001f,
			-7.945142388343811035e-001f, -9.970862865447998047e-001f, -8.691376447677612305e-001f,
			-3.668907880783081055e-001f, 5.054494142532348633e-001f, 8.944271802902221680e-001f,
			4.126977622509002686e-001f, -5.547001957893371582e-001f, -9.351929426193237305e-001f,
			-9.863939285278320312e-001f, -7.835779190063476562e-001f, -3.713906705379486084e-001f,
			2.114935219287872314e-001f, 7.309406399726867676e-001f, 9.596829414367675781e-001f,
			-6.655790805816650391e-001f, -9.952678680419921875e-001f, -9.133164882659912109e-001f,
			-6.290726661682128906e-001f, -2.153099924325942993e-001f, 2.604427933692932129e-001f,
			8.000000119209289551e-001f, 9.981652498245239258e-001f, 0.000000000000000000e+000f,
			-9.981652498245239258e-001f, -8.000000119209289551e-001f, -4.365887939929962158e-001f,
			0.000000000000000000e+000f, 4.365887939929962158e-001f, 9.133164882659912109e-001f,
			9.952678680419921875e-001f, 6.655790805816650391e-001f, -9.596829414367675781e-001f,
			-7.309406399726867676e-001f, -2.604427933692932129e-001f, 2.153099924325942993e-001f,
			6.290726661682128906e-001f, 9.944884777069091797e-001f, 9.337818622589111328e-001f,
			6.350517868995666504e-001f, -5.709763988852500916e-002f, -8.773552179336547852e-001f,
			-3.429438173770904541e-002f, 4.985431432723999023e-001f, 8.427693247795104980e-001f,
			9.933940768241882324e-001f, 8.137334585189819336e-001f, 4.108675122261047363e-001f,
			-1.961161345243453979e-001f, -9.359023571014404297e-001f, -3.162277638912200928e-001f,
			5.415630340576171875e-001f, 9.191450476646423340e-001f, 9.642871022224426270e-001f,
			6.511070132255554199e-001f, 1.324190348386764526e-001f, -4.576523900032043457e-001f,
			-9.308230280876159668e-001f, -8.100499510765075684e-001f, 2.527247071266174316e-001f,
			9.172270298004150391e-001f, 9.777119159698486328e-001f, 5.144957304000854492e-001f,
			-1.485542953014373779e-001f, -7.071067690849304199e-001f, -9.889042377471923828e-001f,
			-8.574929237365722656e-001f, -2.099511474370956421e-001f, 7.071067690849304199e-001f,
			9.675381779670715332e-001f, 5.863608717918395996e-001f, -3.654703199863433838e-001f,
			-8.891312479972839355e-001f, -9.911938309669494629e-001f, -7.589859366416931152e-001f,
			-2.648591399192810059e-001f, 3.983650505542755127e-001f, 8.406600952148437500e-001f,
			9.486832618713378906e-001f, -3.522595465183258057e-001f, -9.805806875228881836e-001f,
			-9.116950631141662598e-001f, -5.812381505966186523e-001f, -1.147523149847984314e-001f,
			3.939192891120910645e-001f, 8.668649196624755859e-001f, 9.994117617607116699e-001f,
			4.798414707183837891e-001f, -9.983685612678527832e-001f, -7.724695801734924316e-001f,
			-3.578427135944366455e-001f, 1.048454344272613525e-001f, 5.382750034332275391e-001f,
			9.448713660240173340e-001f, 9.899495244026184082e-001f, 7.486239075660705566e-001f,
			-7.071067690849304199e-001f, -6.629949212074279785e-001f, -1.414213627576828003e-001f,
			3.274416029453277588e-001f, 7.071068286895751953e-001f };
	float[] PD_IM_SMOOTH = { 0.000000000000000000e+000f, 4.365887939929962158e-001f, 8.000000119209289551e-001f,
			9.981652498245239258e-001f, 0.000000000000000000e+000f, -9.981652498245239258e-001f,
			-8.000000119209289551e-001f, -4.365887939929962158e-001f, 2.153099924325942993e-001f,
			6.290726661682128906e-001f, 9.133164882659912109e-001f, 9.952678680419921875e-001f,
			6.655790805816650391e-001f, -9.596829414367675781e-001f, -7.309406399726867676e-001f,
			-2.604427933692932129e-001f, 3.713906705379486084e-001f, 7.835779190063476562e-001f,
			9.863939285278320312e-001f, 9.351930022239685059e-001f, 5.547001957893371582e-001f,
			-4.126977622509002686e-001f, -8.944271802902221680e-001f, -2.114935219287872314e-001f,
			3.668907880783081055e-001f, 8.691376447677612305e-001f, 9.970862865447998047e-001f,
			7.945142388343811035e-001f, 3.051016032695770264e-001f, -3.997647166252136230e-001f,
			-9.874115586280822754e-001f, -5.054494738578796387e-001f, 0.000000000000000000e+000f,
			8.398045897483825684e-001f, 9.701424837112426758e-001f, 5.942171812057495117e-001f,
			0.000000000000000000e+000f, -5.942171812057495117e-001f, -9.701424837112426758e-001f,
			-8.398045897483825684e-001f, -3.668907880783081055e-001f, 5.054494142532348633e-001f,
			9.874114990234375000e-001f, 3.997647166252136230e-001f, -3.051016032695770264e-001f,
			-7.945142388343811035e-001f, -9.970862865447998047e-001f, -8.691376447677612305e-001f,
			-3.713906705379486084e-001f, 2.114935219287872314e-001f, 8.944271802902221680e-001f,
			4.126977622509002686e-001f, -5.547001957893371582e-001f, -9.351929426193237305e-001f,
			-9.863939285278320312e-001f, -7.835779190063476562e-001f, -2.153099924325942993e-001f,
			2.604427933692932129e-001f, 7.309406399726867676e-001f, 9.596829414367675781e-001f,
			-6.655790805816650391e-001f, -9.952678680419921875e-001f, -9.133164882659912109e-001f,
			-6.290726661682128906e-001f, 1.048454344272613525e-001f, 5.382750034332275391e-001f,
			8.668648600578308105e-001f, 9.994117617607116699e-001f, 4.798414707183837891e-001f,
			-9.983685612678527832e-001f, -7.724695801734924316e-001f, -3.578427135944366455e-001f,
			3.274416029453277588e-001f, 7.071068286895751953e-001f, 9.448713660240173340e-001f,
			9.899494647979736328e-001f, 7.486239075660705566e-001f, -7.071067690849304199e-001f,
			-6.629949212074279785e-001f, -1.414213627576828003e-001f, 4.985431432723999023e-001f,
			8.427693247795104980e-001f, 9.944884777069091797e-001f, 9.337818622589111328e-001f,
			6.350517868995666504e-001f, -5.709763988852500916e-002f, -8.773552179336547852e-001f,
			-3.429438173770904541e-002f, 5.415630340576171875e-001f, 9.191449880599975586e-001f,
			9.933940768241882324e-001f, 8.137334585189819336e-001f, 4.108675122261047363e-001f,
			-1.961161345243453979e-001f, -9.359023571014404297e-001f, -3.162277638912200928e-001f,
			2.527247071266174316e-001f, 9.172269701957702637e-001f, 9.642870426177978516e-001f,
			6.511070132255554199e-001f, 1.324190348386764526e-001f, -4.576523900032043457e-001f,
			-9.308230280876159668e-001f, -8.100500106811523438e-001f, -2.099511474370956421e-001f,
			7.071067690849304199e-001f, 9.777119159698486328e-001f, 5.144957304000854492e-001f,
			-1.485542953014373779e-001f, -7.071067690849304199e-001f, -9.889042377471923828e-001f,
			-8.574929237365722656e-001f, -2.648591399192810059e-001f, 3.983650505542755127e-001f,
			9.675382375717163086e-001f, 5.863608717918395996e-001f, -3.654703199863433838e-001f,
			-8.891312479972839355e-001f, -9.911938309669494629e-001f, -7.589859366416931152e-001f,
			-1.147523149847984314e-001f, 3.939192891120910645e-001f, 8.406600952148437500e-001f,
			9.486832618713378906e-001f, -3.522595465183258057e-001f, -9.805806875228881836e-001f,
			-9.116950631141662598e-001f, -5.812381505966186523e-001f, 1.643989831209182739e-001f,
			6.212936043739318848e-001f, 9.284766912460327148e-001f, 9.773793220520019531e-001f,
			4.472135901451110840e-001f, -9.108680486679077148e-001f, -8.320503234863281250e-001f,
			-3.541385531425476074e-001f, 4.072504639625549316e-001f, 7.773465514183044434e-001f,
			9.765458106994628906e-001f, 9.654892683029174805e-001f, 6.824410557746887207e-001f,
			-2.810846269130706787e-001f, -7.463273406028747559e-001f, -9.716906398534774780e-002f,
			6.000000238418579102e-001f, 8.996611237525939941e-001f, 1.000000000000000000e+000f,
			8.996611237525939941e-001f, 6.000000238418579102e-001f, 6.054889410734176636e-002f,
			-1.000000000000000000e+000f, 6.054889410734176636e-002f, 6.824410557746887207e-001f,
			9.654892683029174805e-001f, 9.765458106994628906e-001f, 7.773465514183044434e-001f,
			4.072504639625549316e-001f, -9.716906398534774780e-002f, -7.463273406028747559e-001f,
			-2.810846269130706787e-001f, 4.472135901451110840e-001f, 9.773793220520019531e-001f,
			9.284766912460327148e-001f, 6.212936043739318848e-001f, 1.643989831209182739e-001f,
			-3.541385531425476074e-001f, -8.320503234863281250e-001f, -9.108680486679077148e-001f,
			-1.581720858812332153e-001f, 8.628561496734619141e-001f, 9.302640557289123535e-001f,
			4.945702552795410156e-001f, -7.628192752599716187e-002f, -6.072454452514648438e-001f,
			-9.523198604583740234e-001f, -9.166177511215209961e-001f, -2.425356209278106689e-001f,
			5.428888201713562012e-001f, 1.000000000000000000e+000f, 5.428888201713562012e-001f,
			-2.425356209278106689e-001f, -8.043046593666076660e-001f, -1.000000000000000000e+000f,
			-8.043046593666076660e-001f, -7.628192752599716187e-002f, 4.945702552795410156e-001f,
			9.302640557289123535e-001f, 8.628562688827514648e-001f, -1.581720858812332153e-001f,
			-9.166177511215209961e-001f, -9.523198604583740234e-001f, -6.072454452514648438e-001f,
			1.324190348386764526e-001f, 6.511070132255554199e-001f, 9.642870426177978516e-001f,
			9.172269701957702637e-001f, 2.527247071266174316e-001f, -8.100500106811523438e-001f,
			-9.308230280876159668e-001f, -4.576523900032043457e-001f, 4.108675122261047363e-001f,
			8.137334585189819336e-001f, 9.933940768241882324e-001f, 9.191449880599975586e-001f,
			5.415630340576171875e-001f, -3.162277638912200928e-001f, -9.359023571014404297e-001f,
			-1.961161345243453979e-001f, 6.350517868995666504e-001f, 9.337818622589111328e-001f,
			9.944884777069091797e-001f, 8.427693247795104980e-001f, 4.985431432723999023e-001f,
			-3.429438173770904541e-002f, -8.773552179336547852e-001f, -5.709763988852500916e-002f,
			7.486239075660705566e-001f, 9.899494647979736328e-001f, 9.448713660240173340e-001f,
			7.071068286895751953e-001f, 3.274416029453277588e-001f, -1.414213627576828003e-001f,
			-6.629949212074279785e-001f, -7.071067690849304199e-001f, 4.798414707183837891e-001f,
			9.994117617607116699e-001f, 8.668648600578308105e-001f, 5.382750034332275391e-001f,
			1.048454344272613525e-001f, -3.578427135944366455e-001f, -7.724695801734924316e-001f,
			-9.983685612678527832e-001f, -3.522595465183258057e-001f, 9.486832618713378906e-001f,
			8.406600952148437500e-001f, 3.939192891120910645e-001f, -1.147523149847984314e-001f,
			-5.812381505966186523e-001f, -9.116950631141662598e-001f, -9.805806875228881836e-001f,
			-3.654703199863433838e-001f, 5.863608717918395996e-001f, 9.675382375717163086e-001f,
			3.983650505542755127e-001f, -2.648591399192810059e-001f, -7.589859366416931152e-001f,
			-9.911938309669494629e-001f, -8.891312479972839355e-001f, -1.485542953014373779e-001f,
			5.144957900047302246e-001f, 9.777119159698486328e-001f, 7.071067690849304199e-001f,
			-2.099511474370956421e-001f, -8.574929237365722656e-001f, -9.889042377471923828e-001f,
			-7.071067690849304199e-001f, 0.000000000000000000e+000f, 5.942171812057495117e-001f,
			9.701424837112426758e-001f, 8.398045897483825684e-001f, 0.000000000000000000e+000f,
			-8.398045897483825684e-001f, -9.701424837112426758e-001f, -5.942171812057495117e-001f,
			3.051016032695770264e-001f, 7.945142388343811035e-001f, 9.970862865447998047e-001f,
			8.691376447677612305e-001f, 3.668907880783081055e-001f, -5.054494738578796387e-001f,
			-9.874115586280822754e-001f, -3.997647166252136230e-001f, 5.547001957893371582e-001f,
			9.351929426193237305e-001f, 9.863939285278320312e-001f, 7.835779190063476562e-001f,
			3.713906705379486084e-001f, -2.114935219287872314e-001f, -8.944271802902221680e-001f,
			-4.126977622509002686e-001f, 6.655790805816650391e-001f, 9.952678680419921875e-001f,
			9.133164882659912109e-001f, 6.290726661682128906e-001f, 2.153099924325942993e-001f,
			-2.604427933692932129e-001f, -7.309406399726867676e-001f, -9.596829414367675781e-001f,
			0.000000000000000000e+000f, 9.981652498245239258e-001f, 8.000000119209289551e-001f,
			4.365887939929962158e-001f, 0.000000000000000000e+000f, -4.365887939929962158e-001f,
			-8.000000119209289551e-001f, -9.981652498245239258e-001f, -6.655790805816650391e-001f,
			9.596829414367675781e-001f, 7.309406399726867676e-001f, 2.604427933692932129e-001f,
			-2.153099924325942993e-001f, -6.290726661682128906e-001f, -9.133164882659912109e-001f,
			-9.952678680419921875e-001f, -5.547001957893371582e-001f, 4.126977622509002686e-001f,
			8.944271802902221680e-001f, 2.114935219287872314e-001f, -3.713906705379486084e-001f,
			-7.835779190063476562e-001f, -9.863939285278320312e-001f, -9.351929426193237305e-001f,
			-3.051016032695770264e-001f, 3.997647166252136230e-001f, 9.874114990234375000e-001f,
			5.054494142532348633e-001f, -3.668907880783081055e-001f, -8.691376447677612305e-001f,
			-9.970862865447998047e-001f, -7.945142388343811035e-001f, -1.324190348386764526e-001f,
			4.576523900032043457e-001f, 9.308229684829711914e-001f, 8.100499510765075684e-001f,
			-2.527247071266174316e-001f, -9.172269701957702637e-001f, -9.642871022224426270e-001f,
			-6.511070132255554199e-001f, 1.485542953014373779e-001f, 7.071067690849304199e-001f,
			9.889042377471923828e-001f, 8.574929237365722656e-001f, 2.099511474370956421e-001f,
			-7.071067690849304199e-001f, -9.777119159698486328e-001f, -5.144957304000854492e-001f,
			3.654703199863433838e-001f, 8.891312479972839355e-001f, 9.911938309669494629e-001f,
			7.589859366416931152e-001f, 2.648591399192810059e-001f, -3.983650505542755127e-001f,
			-9.675381779670715332e-001f, -5.863608121871948242e-001f, 3.522595465183258057e-001f,
			9.805806875228881836e-001f, 9.116950035095214844e-001f, 5.812381505966186523e-001f,
			1.147523149847984314e-001f, -3.939192891120910645e-001f, -8.406600952148437500e-001f,
			-9.486832618713378906e-001f, -4.798414707183837891e-001f, 9.983685612678527832e-001f,
			7.724695801734924316e-001f, 3.578427135944366455e-001f, -1.048454344272613525e-001f,
			-5.382750034332275391e-001f, -8.668649196624755859e-001f, -9.994117617607116699e-001f,
			-7.486239075660705566e-001f, 7.071067690849304199e-001f, 6.629949212074279785e-001f,
			1.414213627576828003e-001f, -3.274416029453277588e-001f, -7.071068286895751953e-001f,
			-9.448713660240173340e-001f, -9.899494647979736328e-001f, -6.350517868995666504e-001f,
			5.709763988852500916e-002f, 8.773551583290100098e-001f, 3.429438173770904541e-002f,
			-4.985431432723999023e-001f, -8.427693247795104980e-001f, -9.944884777069091797e-001f,
			-9.337818622589111328e-001f, -4.108675122261047363e-001f, 1.961161345243453979e-001f,
			9.359023571014404297e-001f, 3.162277638912200928e-001f, -5.415630340576171875e-001f,
			-9.191449880599975586e-001f, -9.933940768241882324e-001f, -8.137334585189819336e-001f,
			-1.643989831209182739e-001f, 3.541385233402252197e-001f, 8.320503234863281250e-001f,
			9.108680486679077148e-001f, -4.472135901451110840e-001f, -9.773793220520019531e-001f,
			-9.284766912460327148e-001f, -6.212936043739318848e-001f, 7.628192752599716187e-002f,
			6.072454452514648438e-001f, 9.523198604583740234e-001f, 9.166177511215209961e-001f,
			1.581720858812332153e-001f, -8.628561496734619141e-001f, -9.302640557289123535e-001f,
			-4.945702552795410156e-001f, 2.425356209278106689e-001f, 8.043046593666076660e-001f,
			1.000000000000000000e+000f, 8.043046593666076660e-001f, 2.425356209278106689e-001f,
			-5.428888201713562012e-001f, -1.000000000000000000e+000f, -5.428888201713562012e-001f,
			1.581720858812332153e-001f, 9.166177511215209961e-001f, 9.523198604583740234e-001f,
			6.072454452514648438e-001f, 7.628192752599716187e-002f, -4.945702552795410156e-001f,
			-9.302640557289123535e-001f, -8.628561496734619141e-001f, -4.472135901451110840e-001f,
			9.108680486679077148e-001f, 8.320503234863281250e-001f, 3.541385233402252197e-001f,
			-1.643989831209182739e-001f, -6.212936043739318848e-001f, -9.284766912460327148e-001f,
			-9.773793220520019531e-001f, -6.824410557746887207e-001f, 2.810846269130706787e-001f,
			7.463273406028747559e-001f, 9.716906398534774780e-002f, -4.072504639625549316e-001f,
			-7.773465514183044434e-001f, -9.765458106994628906e-001f, -9.654892683029174805e-001f,
			-6.000000238418579102e-001f, -6.054889410734176636e-002f, 1.000000000000000000e+000f,
			-6.054889410734176636e-002f, -6.000000238418579102e-001f, -8.996611237525939941e-001f,
			-1.000000000000000000e+000f, -8.996611237525939941e-001f, -4.072504639625549316e-001f,
			9.716906398534774780e-002f, 7.463273406028747559e-001f, 2.810846269130706787e-001f,
			-6.824410557746887207e-001f, -9.654892683029174805e-001f, -9.765458106994628906e-001f,
			-7.773465514183044434e-001f, -1.048454344272613525e-001f, 3.578427135944366455e-001f,
			7.724695801734924316e-001f, 9.983685612678527832e-001f, -4.798414707183837891e-001f,
			-9.994117617607116699e-001f, -8.668649196624755859e-001f, -5.382750034332275391e-001f,
			1.147523149847984314e-001f, 5.812381505966186523e-001f, 9.116950035095214844e-001f,
			9.805806875228881836e-001f, 3.522595465183258057e-001f, -9.486832618713378906e-001f,
			-8.406600952148437500e-001f, -3.939192891120910645e-001f, 2.648591399192810059e-001f,
			7.589859366416931152e-001f, 9.911938309669494629e-001f, 8.891312479972839355e-001f,
			3.654703199863433838e-001f, -5.863608121871948242e-001f, -9.675381779670715332e-001f,
			-3.983650505542755127e-001f, 2.099511474370956421e-001f, 8.574929237365722656e-001f,
			9.889042377471923828e-001f, 7.071067690849304199e-001f, 1.485542953014373779e-001f,
			-5.144957304000854492e-001f, -9.777119159698486328e-001f, -7.071067690849304199e-001f,
			-2.527247071266174316e-001f, 8.100500106811523438e-001f, 9.308229684829711914e-001f,
			4.576523900032043457e-001f, -1.324190348386764526e-001f, -6.511070132255554199e-001f,
			-9.642871022224426270e-001f, -9.172269701957702637e-001f, -5.415630340576171875e-001f,
			3.162277638912200928e-001f, 9.359023571014404297e-001f, 1.961161345243453979e-001f,
			-4.108675122261047363e-001f, -8.137334585189819336e-001f, -9.933940768241882324e-001f,
			-9.191449880599975586e-001f, -4.985431432723999023e-001f, 3.429438173770904541e-002f,
			8.773551583290100098e-001f, 5.709763988852500916e-002f, -6.350517868995666504e-001f,
			-9.337818622589111328e-001f, -9.944884777069091797e-001f, -8.427693247795104980e-001f,
			-3.274416029453277588e-001f, 1.414213627576828003e-001f, 6.629949212074279785e-001f,
			7.071067690849304199e-001f, -7.486239075660705566e-001f, -9.899494647979736328e-001f,
			-9.448713660240173340e-001f, -7.071068286895751953e-001f };
	float[][][] HA = {
			{
					{ 7.940162718296051025e-002f, 1.411982774734497070e+000f, 0.000000000000000000e+000f,
							0.000000000000000000e+000f },
					{ 7.468105107545852661e-002f, 1.411907911300659180e+000f, 2.696959674358367920e-002f,
							-1.454225461930036545e-002f },
					{ 6.748995929956436157e-002f, 1.411790847778320312e+000f, 4.182970523834228516e-002f,
							-2.328188531100749969e-002f },
					{ 4.939322546124458313e-002f, 1.411478400230407715e+000f, 6.216854229569435120e-002f,
							-3.773759678006172180e-002f },
					{ 3.171866759657859802e-002f, 1.411144018173217773e+000f, 7.279109954833984375e-002f,
							-4.866135492920875549e-002f },
					{ 3.598469076678156853e-003f, 1.410531997680664062e+000f, 7.932004332542419434e-002f,
							-6.399089843034744263e-002f },
					{ -4.260054603219032288e-002f, 1.409135818481445312e+000f, 6.700605899095535278e-002f,
							-8.961886912584304810e-002f },
					{ -7.907546311616897583e-002f, 1.406182646751403809e+000f, 7.189543452113866806e-003f,
							-1.278502941131591797e-001f } },
			{
					{ 1.766446232795715332e-001f, 1.403138160705566406e+000f, 0.000000000000000000e+000f,
							0.000000000000000000e+000f },
					{ 1.669309437274932861e-001f, 1.402744650840759277e+000f, 5.777010694146156311e-002f,
							-3.322904184460639954e-002f },
					{ 1.521043181419372559e-001f, 1.402129530906677246e+000f, 8.981981128454208374e-002f,
							-5.319278314709663391e-002f },
					{ 1.146221607923507690e-001f, 1.400488257408142090e+000f, 1.344064176082611084e-001f,
							-8.619292825460433960e-002f },
					{ 7.774547487497329712e-002f, 1.398732423782348633e+000f, 1.586157828569412231e-001f,
							-1.111051514744758606e-001f },
					{ 1.838226616382598877e-002f, 1.395519971847534180e+000f, 1.756855547428131104e-001f,
							-1.460155993700027466e-001f },
					{ -8.216059207916259766e-002f, 1.388199210166931152e+000f, 1.563744246959686279e-001f,
							-2.042046636343002319e-001f },
					{ -1.728187799453735352e-001f, 1.372748374938964844e+000f, 3.656492754817008972e-002f,
							-2.904456555843353271e-001f } },
			{
					{ 2.767182886600494385e-001f, 1.386876702308654785e+000f, 0.000000000000000000e+000f,
							0.000000000000000000e+000f },
					{ 2.628016471862792969e-001f, 1.385856389999389648e+000f, 8.665049076080322266e-002f,
							-5.319010466337203979e-002f },
					{ 2.415156662464141846e-001f, 1.384261727333068848e+000f, 1.350673735141754150e-001f,
							-8.512610197067260742e-002f },
					{ 1.874468326568603516e-001f, 1.380008816719055176e+000f, 2.035600543022155762e-001f,
							-1.378498524427413940e-001f },
					{ 1.338444054126739502e-001f, 1.375461816787719727e+000f, 2.421955615282058716e-001f,
							-1.775719672441482544e-001f },
					{ 4.650494828820228577e-002f, 1.367151141166687012e+000f, 2.727825045585632324e-001f,
							-2.330769300460815430e-001f },
					{ -1.060376241803169250e-001f, 1.348250269889831543e+000f, 2.555954456329345703e-001f,
							-3.250358700752258301e-001f },
					{ -2.610871493816375732e-001f, 1.308535456657409668e+000f, 9.168701618909835815e-002f,
							-4.595237374305725098e-001f } },
			{
					{ 4.264014363288879395e-001f, 1.348399758338928223e+000f, 0.000000000000000000e+000f,
							0.000000000000000000e+000f },
					{ 4.080123305320739746e-001f, 1.345800518989562988e+000f, 1.238714233040809631e-001f,
							-8.368386328220367432e-002f },
					{ 3.797967433929443359e-001f, 1.341740369796752930e+000f, 1.938365548849105835e-001f,
							-1.338454335927963257e-001f },
					{ 3.076064586639404297e-001f, 1.330924391746520996e+000f, 2.952904403209686279e-001f,
							-2.163843065500259399e-001f },
					{ 2.352139651775360107e-001f, 1.319380164146423340e+000f, 3.556579351425170898e-001f,
							-2.782405912876129150e-001f },
					{ 1.151135414838790894e-001f, 1.298333764076232910e+000f, 4.105691909790039062e-001f,
							-3.640210330486297607e-001f },
					{ -1.041954904794692993e-001f, 1.250724673271179199e+000f, 4.134748876094818115e-001f,
							-5.038546919822692871e-001f },
					{ -3.642481267452239990e-001f, 1.151853680610656738e+000f, 2.216787636280059814e-001f,
							-7.010099291801452637e-001f } },
			{
					{ 5.767799019813537598e-001f, 1.291249394416809082e+000f, 0.000000000000000000e+000f,
							0.000000000000000000e+000f },
					{ 5.561030507087707520e-001f, 1.286220550537109375e+000f, 1.530504822731018066e-001f,
							-1.138497889041900635e-001f },
					{ 5.242760181427001953e-001f, 1.278372049331665039e+000f, 2.404365390539169312e-001f,
							-1.819063574075698853e-001f },
					{ 4.422511458396911621e-001f, 1.257503151893615723e+000f, 3.702552914619445801e-001f,
							-2.932760715484619141e-001f },
					{ 3.590498268604278564e-001f, 1.235292673110961914e+000f, 4.513959288597106934e-001f,
							-3.760015368461608887e-001f },
					{ 2.185433506965637207e-001f, 1.194969415664672852e+000f, 5.337732434272766113e-001f,
							-4.892577528953552246e-001f },
					{ -4.919422417879104614e-002f, 1.104566812515258789e+000f, 5.746781826019287109e-001f,
							-6.687729358673095703e-001f },
					{ -4.111666679382324219e-001f, 9.204873442649841309e-001f, 4.044960141181945801e-001f,
							-9.055539965629577637e-001f } },
			{
					{ 7.546486258506774902e-001f, 1.196037411689758301e+000f, 0.000000000000000000e+000f,
							0.000000000000000000e+000f },
					{ 7.340615391731262207e-001f, 1.187039732933044434e+000f, 1.750661730766296387e-001f,
							-1.464318484067916870e-001f },
					{ 7.022541761398315430e-001f, 1.173018932342529297e+000f, 2.762853503227233887e-001f,
							-2.335211932659149170e-001f },
					{ 6.195814013481140137e-001f, 1.135867953300476074e+000f, 4.308287501335144043e-001f,
							-3.745791614055633545e-001f },
					{ 5.346061587333679199e-001f, 1.096537113189697266e+000f, 5.326263308525085449e-001f,
							-4.776105880737304688e-001f },
					{ 3.881656527519226074e-001f, 1.025686621665954590e+000f, 6.471645832061767578e-001f,
							-6.152011752128601074e-001f },
					{ 9.563652426004409790e-002f, 8.694874644279479980e-001f, 7.485640645027160645e-001f,
							-8.212776780128479004e-001f },
					{ -3.553301692008972168e-001f, 5.631601214408874512e-001f, 6.657589673995971680e-001f,
							-1.055156946182250977e+000f } },
			{
					{ 8.796171545982360840e-001f, 1.107372403144836426e+000f, 0.000000000000000000e+000f,
							0.000000000000000000e+000f },
					{ 8.608095049858093262e-001f, 1.094988703727722168e+000f, 1.809234470129013062e-001f,
							-1.651468127965927124e-001f },
					{ 8.316769599914550781e-001f, 1.075721979141235352e+000f, 2.864258289337158203e-001f,
							-2.628610730171203613e-001f },
					{ 7.555164694786071777e-001f, 1.024850845336914062e+000f, 4.504677951335906982e-001f,
							-4.194690585136413574e-001f },
					{ 6.765303611755371094e-001f, 9.712837934494018555e-001f, 5.621681213378906250e-001f,
							-5.318660140037536621e-001f },
					{ 5.385516881942749023e-001f, 8.755537867546081543e-001f, 6.954771280288696289e-001f,
							-6.779964566230773926e-001f },
					{ 2.542968690395355225e-001f, 6.681280732154846191e-001f, 8.420566916465759277e-001f,
							-8.831073045730590820e-001f },
					{ -2.201531976461410522e-001f, 2.771563827991485596e-001f, 8.516213297843933105e-001f,
							-1.072127819061279297e+000f } },
			{
					{ 1.000000000000000000e+000f, 1.000000000000000000e+000f, 0.000000000000000000e+000f,
							0.000000000000000000e+000f },
					{ 9.841240048408508301e-001f, 9.841240048408508301e-001f, 1.774823963642120361e-001f,
							-1.774823963642120361e-001f },
					{ 9.594737887382507324e-001f, 9.594737887382507324e-001f, 2.817977964878082275e-001f,
							-2.817977964878082275e-001f },
					{ 8.946843147277832031e-001f, 8.946843147277832031e-001f, 4.466989934444427490e-001f,
							-4.466989934444427490e-001f },
					{ 8.269340991973876953e-001f, 8.269340991973876953e-001f, 5.622988343238830566e-001f,
							-5.622988343238830566e-001f },
					{ 7.071067690849304199e-001f, 7.071067690849304199e-001f, 7.071067690849304199e-001f,
							-7.071067690849304199e-001f },
					{ 4.533211290836334229e-001f, 4.533211290836334229e-001f, 8.913472890853881836e-001f,
							-8.913472890853881836e-001f },
					{ -4.371138828673792887e-008f, -4.371138828673792887e-008f, 1.000000000000000000e+000f,
							-1.000000000000000000e+000f } },
			{
					{ 1.107372403144836426e+000f, 8.796171545982360840e-001f, 0.000000000000000000e+000f,
							-0.000000000000000000e+000f },
					{ 1.094988703727722168e+000f, 8.608095049858093262e-001f, 1.651468127965927124e-001f,
							-1.809234470129013062e-001f },
					{ 1.075721979141235352e+000f, 8.316769599914550781e-001f, 2.628610730171203613e-001f,
							-2.864258289337158203e-001f },
					{ 1.024850845336914062e+000f, 7.555164694786071777e-001f, 4.194690585136413574e-001f,
							-4.504677951335906982e-001f },
					{ 9.712837934494018555e-001f, 6.765303611755371094e-001f, 5.318660140037536621e-001f,
							-5.621681213378906250e-001f },
					{ 8.755537867546081543e-001f, 5.385516881942749023e-001f, 6.779964566230773926e-001f,
							-6.954771280288696289e-001f },
					{ 6.681280732154846191e-001f, 2.542969882488250732e-001f, 8.831073045730590820e-001f,
							-8.420566320419311523e-001f },
					{ 2.771563827991485596e-001f, -2.201531976461410522e-001f, 1.072127819061279297e+000f,
							-8.516213297843933105e-001f } },
			{
					{ 1.196037411689758301e+000f, 7.546485662460327148e-001f, 0.000000000000000000e+000f,
							-0.000000000000000000e+000f },
					{ 1.187039732933044434e+000f, 7.340614795684814453e-001f, 1.464318335056304932e-001f,
							-1.750661581754684448e-001f },
					{ 1.173018932342529297e+000f, 7.022541165351867676e-001f, 2.335211783647537231e-001f,
							-2.762853205204010010e-001f },
					{ 1.135867953300476074e+000f, 6.195813417434692383e-001f, 3.745791316032409668e-001f,
							-4.308287203311920166e-001f },
					{ 1.096537113189697266e+000f, 5.346060395240783691e-001f, 4.776105284690856934e-001f,
							-5.326263308525085449e-001f },
					{ 1.025686621665954590e+000f, 3.881656229496002197e-001f, 6.152011156082153320e-001f,
							-6.471645236015319824e-001f },
					{ 8.694874644279479980e-001f, 9.563651680946350098e-002f, 8.212776780128479004e-001f,
							-7.485640645027160645e-001f },
					{ 5.631602406501770020e-001f, -3.553301393985748291e-001f, 1.055156826972961426e+000f,
							-6.657589077949523926e-001f } },
			{
					{ 1.291249394416809082e+000f, 5.767799019813537598e-001f, 0.000000000000000000e+000f,
							-0.000000000000000000e+000f },
					{ 1.286220550537109375e+000f, 5.561030507087707520e-001f, 1.138497889041900635e-001f,
							-1.530504673719406128e-001f },
					{ 1.278372049331665039e+000f, 5.242760181427001953e-001f, 1.819063574075698853e-001f,
							-2.404365390539169312e-001f },
					{ 1.257503151893615723e+000f, 4.422511756420135498e-001f, 2.932760715484619141e-001f,
							-3.702552616596221924e-001f },
					{ 1.235292673110961914e+000f, 3.590498268604278564e-001f, 3.760015368461608887e-001f,
							-4.513959288597106934e-001f },
					{ 1.194969415664672852e+000f, 2.185434103012084961e-001f, 4.892577528953552246e-001f,
							-5.337731838226318359e-001f },
					{ 1.104566812515258789e+000f, -4.919422417879104614e-002f, 6.687729358673095703e-001f,
							-5.746781826019287109e-001f },
					{ 9.204873442649841309e-001f, -4.111665785312652588e-001f, 9.055539965629577637e-001f,
							-4.044961333274841309e-001f } },
			{
					{ 1.348399758338928223e+000f, 4.264014065265655518e-001f, 0.000000000000000000e+000f,
							-0.000000000000000000e+000f },
					{ 1.345800518989562988e+000f, 4.080123007297515869e-001f, 8.368386328220367432e-002f,
							-1.238714158535003662e-001f },
					{ 1.341740369796752930e+000f, 3.797967135906219482e-001f, 1.338454335927963257e-001f,
							-1.938365399837493896e-001f },
					{ 1.330924391746520996e+000f, 3.076064586639404297e-001f, 2.163843214511871338e-001f,
							-2.952904105186462402e-001f },
					{ 1.319380164146423340e+000f, 2.352139204740524292e-001f, 2.782405912876129150e-001f,
							-3.556579351425170898e-001f },
					{ 1.298333764076232910e+000f, 1.151135340332984924e-001f, 3.640210032463073730e-001f,
							-4.105691611766815186e-001f },
					{ 1.250724673271179199e+000f, -1.041954830288887024e-001f, 5.038547515869140625e-001f,
							-4.134748578071594238e-001f },
					{ 1.151853799819946289e+000f, -3.642481267452239990e-001f, 7.010098695755004883e-001f,
							-2.216787487268447876e-001f } },
			{
					{ 1.386876702308654785e+000f, 2.767182886600494385e-001f, 0.000000000000000000e+000f,
							-0.000000000000000000e+000f },
					{ 1.385856389999389648e+000f, 2.628016471862792969e-001f, 5.319009721279144287e-002f,
							-8.665049076080322266e-002f },
					{ 1.384261727333068848e+000f, 2.415156662464141846e-001f, 8.512609452009201050e-002f,
							-1.350673586130142212e-001f },
					{ 1.380008816719055176e+000f, 1.874468326568603516e-001f, 1.378498673439025879e-001f,
							-2.035600692033767700e-001f },
					{ 1.375461816787719727e+000f, 1.338444054126739502e-001f, 1.775719672441482544e-001f,
							-2.421955615282058716e-001f },
					{ 1.367151141166687012e+000f, 4.650494828820228577e-002f, 2.330769002437591553e-001f,
							-2.727825045585632324e-001f },
					{ 1.348250269889831543e+000f, -1.060376241803169250e-001f, 3.250358998775482178e-001f,
							-2.555954456329345703e-001f },
					{ 1.308535456657409668e+000f, -2.610871493816375732e-001f, 4.595236778259277344e-001f,
							-9.168701618909835815e-002f } },
			{
					{ 1.403138160705566406e+000f, 1.766446232795715332e-001f, 0.000000000000000000e+000f,
							-0.000000000000000000e+000f },
					{ 1.402744650840759277e+000f, 1.669309437274932861e-001f, 3.322903439402580261e-002f,
							-5.777010694146156311e-002f },
					{ 1.402129530906677246e+000f, 1.521043181419372559e-001f, 5.319278314709663391e-002f,
							-8.981981128454208374e-002f },
					{ 1.400488257408142090e+000f, 1.146221682429313660e-001f, 8.619291335344314575e-002f,
							-1.344064027070999146e-001f },
					{ 1.398732423782348633e+000f, 7.774547487497329712e-002f, 1.111051887273788452e-001f,
							-1.586157828569412231e-001f },
					{ 1.395519971847534180e+000f, 1.838226616382598877e-002f, 1.460155546665191650e-001f,
							-1.756855547428131104e-001f },
					{ 1.388199210166931152e+000f, -8.216055482625961304e-002f, 2.042046338319778442e-001f,
							-1.563744395971298218e-001f },
					{ 1.372748374938964844e+000f, -1.728187799453735352e-001f, 2.904455959796905518e-001f,
							-3.656492754817008972e-002f } },
			{
					{ 1.411982774734497070e+000f, 7.940161973237991333e-002f, 0.000000000000000000e+000f,
							-0.000000000000000000e+000f },
					{ 1.411907911300659180e+000f, 7.468104362487792969e-002f, 1.454224810004234314e-002f,
							-2.696959488093852997e-002f },
					{ 1.411790847778320312e+000f, 6.748995184898376465e-002f, 2.328187786042690277e-002f,
							-4.182969778776168823e-002f },
					{ 1.411478400230407715e+000f, 4.939322173595428467e-002f, 3.773759678006172180e-002f,
							-6.216853484511375427e-002f },
					{ 1.411144018173217773e+000f, 3.171866387128829956e-002f, 4.866134002804756165e-002f,
							-7.279109209775924683e-002f },
					{ 1.410531997680664062e+000f, 3.598468611016869545e-003f, 6.399089843034744263e-002f,
							-7.932003587484359741e-002f },
					{ 1.409135818481445312e+000f, -4.260054230690002441e-002f, 8.961889147758483887e-002f,
							-6.700605154037475586e-002f },
					{ 1.406182646751403809e+000f, -7.907545566558837891e-002f, 1.278502941131591797e-001f,
							-7.189542986452579498e-003f } },
			{
					{ 4.472113680094480515e-003f, 1.414206504821777344e+000f, 0.000000000000000000e+000f,
							0.000000000000000000e+000f },
					{ 4.191252868622541428e-003f, 1.414206266403198242e+000f, 1.559872180223464966e-003f,
							-7.992055616341531277e-004f },
					{ 3.764039138332009315e-003f, 1.414205908775329590e+000f, 2.414914080873131752e-003f,
							-1.279571792110800743e-003f },
					{ 2.692622598260641098e-003f, 1.414204955101013184e+000f, 3.570656059309840202e-003f,
							-2.074203919619321823e-003f },
					{ 1.651991158723831177e-003f, 1.414204001426696777e+000f, 4.155806265771389008e-003f,
							-2.674792660400271416e-003f },
					{ 1.112435620598262176e-005f, 1.414202094078063965e+000f, 4.472099710255861282e-003f,
							-3.517976263538002968e-003f },
					{ -2.621463732793927193e-003f, 1.414197921752929688e+000f, 3.623220836743712425e-003f,
							-4.928449168801307678e-003f },
					{ -4.472058266401290894e-003f, 1.414188981056213379e+000f, 2.224864329036790878e-005f,
							-7.035930640995502472e-003f } },
			{
					{ 7.952581159770488739e-003f, 1.414191126823425293e+000f, 0.000000000000000000e+000f,
							0.000000000000000000e+000f },
					{ 7.454359903931617737e-003f, 1.414190411567687988e+000f, 2.770571038126945496e-003f,
							-1.422939123585820198e-003f },
					{ 6.696471013128757477e-003f, 1.414189338684082031e+000f, 4.289617761969566345e-003f,
							-2.278168685734272003e-003f },
					{ 4.795447923243045807e-003f, 1.414186358451843262e+000f, 6.344070192426443100e-003f,
							-3.692970611155033112e-003f },
					{ 2.948575653135776520e-003f, 1.414183139801025391e+000f, 7.385760080069303513e-003f,
							-4.762340802699327469e-003f },
					{ 3.522138285916298628e-005f, 1.414177298545837402e+000f, 7.952502928674221039e-003f,
							-6.263491697609424591e-003f },
					{ -4.644102882593870163e-003f, 1.414163947105407715e+000f, 6.455684080719947815e-003f,
							-8.774778805673122406e-003f },
					{ -7.952269166707992554e-003f, 1.414135694503784180e+000f, 7.044207450235262513e-005f,
							-1.252686139196157455e-002f } },
			{
					{ 1.414142828434705734e-002f, 1.414142847061157227e+000f, 0.000000000000000000e+000f,
							0.000000000000000000e+000f },
					{ 1.325935497879981995e-002f, 1.414140582084655762e+000f, 4.916248377412557602e-003f,
							-2.535721287131309509e-003f },
					{ 1.191739086061716080e-002f, 1.414137005805969238e+000f, 7.612870074808597565e-003f,
							-4.059755243360996246e-003f },
					{ 8.550376631319522858e-003f, 1.414127588272094727e+000f, 1.126370485872030258e-002f,
							-6.580919492989778519e-003f },
					{ 5.277783609926700592e-003f, 1.414117336273193359e+000f, 1.311964169144630432e-002f,
							-8.486551232635974884e-003f },
					{ 1.116143539547920227e-004f, 1.414098739624023438e+000f, 1.414098776876926422e-002f,
							-1.116158161312341690e-002f },
					{ -8.202425204217433929e-003f, 1.414056420326232910e+000f, 1.151955779641866684e-002f,
							-1.563672907650470734e-002f },
					{ -1.413966622203588486e-002f, 1.413966655731201172e+000f, 2.232217520941048861e-004f,
							-2.232246845960617065e-002f } },
			{
					{ 2.514469251036643982e-002f, 1.413990020751953125e+000f, 0.000000000000000000e+000f,
							0.000000000000000000e+000f },
					{ 2.358856983482837677e-002f, 1.413982748985290527e+000f, 8.708325214684009552e-003f,
							-4.525679629296064377e-003f },
					{ 2.122061140835285187e-002f, 1.413971424102783203e+000f, 1.348855998367071152e-002f,
							-7.245720364153385162e-003f },
					{ 1.527637522667646408e-002f, 1.413941264152526855e+000f, 1.997217908501625061e-002f,
							-1.174534671008586884e-002f },
					{ 9.494144469499588013e-003f, 1.413908839225769043e+000f, 2.328340150415897369e-002f,
							-1.514632627367973328e-002f },
					{ 3.542384656611829996e-004f, 1.413849711418151855e+000f, 2.514219656586647034e-002f,
							-1.992035470902919769e-002f },
					{ -1.440629176795482635e-002f, 1.413714647293090820e+000f, 2.060859836637973785e-002f,
							-2.790662273764610291e-002f },
					{ -2.513471059501171112e-002f, 1.413428783416748047e+000f, 7.084066164679825306e-004f,
							-3.983675688505172729e-002f } },
			{
					{ 4.469901323318481445e-002f, 1.413506984710693359e+000f, 0.000000000000000000e+000f,
							0.000000000000000000e+000f },
					{ 4.197173938155174255e-002f, 1.413483738899230957e+000f, 1.537448633462190628e-002f,
							-8.097543381154537201e-003f },
					{ 3.782002627849578857e-002f, 1.413447499275207520e+000f, 2.382535301148891449e-002f,
							-1.296424120664596558e-002f },
					{ 2.738874219357967377e-002f, 1.413350701332092285e+000f, 3.532504290342330933e-002f,
							-2.101481333374977112e-002f },
					{ 1.722706854343414307e-002f, 1.413247227668762207e+000f, 4.124596714973449707e-002f,
							-2.709937654435634613e-002f },
					{ 1.127029536291956902e-003f, 1.413057565689086914e+000f, 4.468480125069618225e-002f,
							-3.563994914293289185e-002f },
					{ -2.503543719649314880e-002f, 1.412625074386596680e+000f, 3.703010454773902893e-002f,
							-4.992485418915748596e-002f },
					{ -4.464218020439147949e-002f, 1.411709785461425781e+000f, 2.253342419862747192e-003f,
							-7.125724107027053833e-002f } },
			{
					{ 7.940162718296051025e-002f, 1.411982774734497070e+000f, 0.000000000000000000e+000f,
							0.000000000000000000e+000f },
					{ 7.468105107545852661e-002f, 1.411907911300659180e+000f, 2.696959674358367920e-002f,
							-1.454225461930036545e-002f },
					{ 6.748995929956436157e-002f, 1.411790847778320312e+000f, 4.182970523834228516e-002f,
							-2.328188531100749969e-002f },
					{ 4.939322546124458313e-002f, 1.411478400230407715e+000f, 6.216854229569435120e-002f,
							-3.773759678006172180e-002f },
					{ 3.171866759657859802e-002f, 1.411144018173217773e+000f, 7.279109954833984375e-002f,
							-4.866135492920875549e-002f },
					{ 3.598469076678156853e-003f, 1.410531997680664062e+000f, 7.932004332542419434e-002f,
							-6.399089843034744263e-002f },
					{ -4.260054603219032288e-002f, 1.409135818481445312e+000f, 6.700605899095535278e-002f,
							-8.961886912584304810e-002f },
					{ -7.907546311616897583e-002f, 1.406182646751403809e+000f, 7.189543452113866806e-003f,
							-1.278502941131591797e-001f } },
			{
					{ 1.119822487235069275e-001f, 1.409772992134094238e+000f, 0.000000000000000000e+000f,
							0.000000000000000000e+000f },
					{ 1.054906323552131653e-001f, 1.409620881080627441e+000f, 3.757327049970626831e-002f,
							-2.070707269012928009e-002f },
					{ 9.559512883424758911e-002f, 1.409383177757263184e+000f, 5.832320079207420349e-002f,
							-3.315071761608123779e-002f },
					{ 7.065486907958984375e-002f, 1.408748745918273926e+000f, 8.687873184680938721e-002f,
							-5.372988432645797729e-002f },
					{ 4.623692482709884644e-002f, 1.408069849014282227e+000f, 1.019910350441932678e-001f,
							-6.927720457315444946e-002f },
					{ 7.235344499349594116e-003f, 1.406827211380004883e+000f, 1.117482632398605347e-001f,
							-9.108765423297882080e-002f },
					{ -5.750105157494544983e-002f, 1.403993368148803711e+000f, 9.609190374612808228e-002f,
							-1.275241822004318237e-001f },
					{ -1.110472753643989563e-001f, 1.398002386093139648e+000f, 1.444045267999172211e-002f,
							-1.817946434020996094e-001f } },
			{
					{ 1.576878875494003296e-001f, 1.405394792556762695e+000f, 0.000000000000000000e+000f,
							0.000000000000000000e+000f },
					{ 1.488780677318572998e-001f, 1.405084729194641113e+000f, 5.196911841630935669e-002f,
							-2.952196449041366577e-002f },
					{ 1.354363113641738892e-001f, 1.404599905014038086e+000f, 8.076183497905731201e-002f,
							-4.726001992821693420e-002f },
					{ 1.014855280518531799e-001f, 1.403306484222412109e+000f, 1.206903383135795593e-001f,
							-7.658590376377105713e-002f },
					{ 6.813107430934906006e-002f, 1.401922583580017090e+000f, 1.422097980976104736e-001f,
							-9.873023629188537598e-002f },
					{ 1.456081587821245193e-002f, 1.399390339851379395e+000f, 1.570141762495040894e-001f,
							-1.297734677791595459e-001f },
					{ -7.563733309507369995e-002f, 1.393618106842041016e+000f, 1.383635252714157104e-001f,
							-1.815574318170547485e-001f },
					{ -1.549988090991973877e-001f, 1.381428360939025879e+000f, 2.899721264839172363e-002f,
							-2.584380507469177246e-001f } },
			{
					{ 2.213746458292007446e-001f, 1.396779537200927734e+000f, 0.000000000000000000e+000f,
							0.000000000000000000e+000f },
					{ 2.096635699272155762e-001f, 1.396145582199096680e+000f, 7.104872912168502808e-002f,
							-4.207841306924819946e-002f },
					{ 1.917717009782791138e-001f, 1.395154714584350586e+000f, 1.105909124016761780e-001f,
							-6.735271215438842773e-002f },
					{ 1.464443653821945190e-001f, 1.392511367797851562e+000f, 1.660144031047821045e-001f,
							-1.091111600399017334e-001f },
					{ 1.016974225640296936e-001f, 1.389683961868286133e+000f, 1.966325789690017700e-001f,
							-1.406111270189285278e-001f },
					{ 2.927377820014953613e-002f, 1.384513258934020996e+000f, 2.194305807352066040e-001f,
							-1.847051084041595459e-001f },
					{ -9.509639441967010498e-002f, 1.372738838195800781e+000f, 1.999084949493408203e-001f,
							-2.580333352088928223e-001f },
					{ -2.136325240135192871e-001f, 1.347930073738098145e+000f, 5.803340673446655273e-002f,
							-3.661661446094512939e-001f } },
			{
					{ 3.089554011821746826e-001f, 1.380053043365478516e+000f, 0.000000000000000000e+000f,
							0.000000000000000000e+000f },
					{ 2.938907146453857422e-001f, 1.378760099411010742e+000f, 9.529791027307510376e-002f,
							-5.972388386726379395e-002f },
					{ 2.708331942558288574e-001f, 1.376739740371704102e+000f, 1.486701816320419312e-001f,
							-9.557281434535980225e-002f },
					{ 2.121736705303192139e-001f, 1.371352314949035645e+000f, 2.245790958404541016e-001f,
							-1.547235399484634399e-001f },
					{ 1.538765430450439453e-001f, 1.365593910217285156e+000f, 2.679094076156616211e-001f,
							-1.992480605840682983e-001f },
					{ 5.851671472191810608e-002f, 1.355073571205139160e+000f, 3.033632040023803711e-001f,
							-2.613846063613891602e-001f },
					{ -1.096648275852203369e-001f, 1.331169128417968750e+000f, 2.888374328613281250e-001f,
							-3.640535771846771240e-001f },
					{ -2.867890596389770508e-001f, 1.281039595603942871e+000f, 1.149150878190994263e-001f,
							-5.133069157600402832e-001f } },
			{
					{ 4.264014363288879395e-001f, 1.348399758338928223e+000f, 0.000000000000000000e+000f,
							0.000000000000000000e+000f },
					{ 4.080123305320739746e-001f, 1.345800518989562988e+000f, 1.238714233040809631e-001f,
							-8.368386328220367432e-002f },
					{ 3.797967433929443359e-001f, 1.341740369796752930e+000f, 1.938365548849105835e-001f,
							-1.338454335927963257e-001f },
					{ 3.076064586639404297e-001f, 1.330924391746520996e+000f, 2.952904403209686279e-001f,
							-2.163843065500259399e-001f },
					{ 2.352139651775360107e-001f, 1.319380164146423340e+000f, 3.556579351425170898e-001f,
							-2.782405912876129150e-001f },
					{ 1.151135414838790894e-001f, 1.298333764076232910e+000f, 4.105691909790039062e-001f,
							-3.640210330486297607e-001f },
					{ -1.041954904794692993e-001f, 1.250724673271179199e+000f, 4.134748876094818115e-001f,
							-5.038546919822692871e-001f },
					{ -3.642481267452239990e-001f, 1.151853680610656738e+000f, 2.216787636280059814e-001f,
							-7.010099291801452637e-001f } },
			{
					{ 5.230810046195983887e-001f, 1.313920140266418457e+000f, 0.000000000000000000e+000f,
							0.000000000000000000e+000f },
					{ 5.029684305191040039e-001f, 1.309858441352844238e+000f, 1.436541676521301270e-001f,
							-1.032326966524124146e-001f },
					{ 4.720450937747955322e-001f, 1.303517222404479980e+000f, 2.253601104021072388e-001f,
							-1.650118827819824219e-001f },
					{ 3.925557136535644531e-001f, 1.286643147468566895e+000f, 3.457076251506805420e-001f,
							-2.663372159004211426e-001f },
					{ 3.122535943984985352e-001f, 1.268663287162780762e+000f, 4.196563363075256348e-001f,
							-3.418763875961303711e-001f },
					{ 1.774935871362686157e-001f, 1.235965013504028320e+000f, 4.920465052127838135e-001f,
							-4.458437561988830566e-001f },
					{ -7.548456639051437378e-002f, 1.162387609481811523e+000f, 5.176058411598205566e-001f,
							-6.125692725181579590e-001f },
					{ -4.026255905628204346e-001f, 1.011349797248840332e+000f, 3.339256942272186279e-001f,
							-8.387835025787353516e-001f } },
			{
					{ 6.336560249328613281e-001f, 1.264310121536254883e+000f, 0.000000000000000000e+000f,
							0.000000000000000000e+000f },
					{ 6.126841306686401367e-001f, 1.258136987686157227e+000f, 1.616729050874710083e-001f,
							-1.247857734560966492e-001f },
					{ 5.803641080856323242e-001f, 1.248506665229797363e+000f, 2.543569803237915039e-001f,
							-1.992766410112380981e-001f },
					{ 4.968406260013580322e-001f, 1.222924351692199707e+000f, 3.932802677154541016e-001f,
							-3.208367824554443359e-001f },
					{ 4.117560088634490967e-001f, 1.195736289024353027e+000f, 4.816398620605468750e-001f,
							-4.107245802879333496e-001f },
					{ 2.671199440956115723e-001f, 1.146480798721313477e+000f, 5.746015310287475586e-001f,
							-5.329744815826416016e-001f },
					{ -1.278852019459009171e-002f, 1.036551952362060547e+000f, 6.335269808769226074e-001f,
							-7.239061594009399414e-001f },
					{ -4.084452986717224121e-001f, 8.149554729461669922e-001f, 4.844506084918975830e-001f,
							-9.666062593460083008e-001f } },
			{
					{ 7.546486258506774902e-001f, 1.196037411689758301e+000f, 0.000000000000000000e+000f,
							0.000000000000000000e+000f },
					{ 7.340615391731262207e-001f, 1.187039732933044434e+000f, 1.750661730766296387e-001f,
							-1.464318484067916870e-001f },
					{ 7.022541761398315430e-001f, 1.173018932342529297e+000f, 2.762853503227233887e-001f,
							-2.335211932659149170e-001f },
					{ 6.195814013481140137e-001f, 1.135867953300476074e+000f, 4.308287501335144043e-001f,
							-3.745791614055633545e-001f },
					{ 5.346061587333679199e-001f, 1.096537113189697266e+000f, 5.326263308525085449e-001f,
							-4.776105880737304688e-001f },
					{ 3.881656527519226074e-001f, 1.025686621665954590e+000f, 6.471645832061767578e-001f,
							-6.152011752128601074e-001f },
					{ 9.563652426004409790e-002f, 8.694874644279479980e-001f, 7.485640645027160645e-001f,
							-8.212776780128479004e-001f },
					{ -3.553301692008972168e-001f, 5.631601214408874512e-001f, 6.657589673995971680e-001f,
							-1.055156946182250977e+000f } },
			{
					{ 8.796171545982360840e-001f, 1.107372403144836426e+000f, 0.000000000000000000e+000f,
							0.000000000000000000e+000f },
					{ 8.608095049858093262e-001f, 1.094988703727722168e+000f, 1.809234470129013062e-001f,
							-1.651468127965927124e-001f },
					{ 8.316769599914550781e-001f, 1.075721979141235352e+000f, 2.864258289337158203e-001f,
							-2.628610730171203613e-001f },
					{ 7.555164694786071777e-001f, 1.024850845336914062e+000f, 4.504677951335906982e-001f,
							-4.194690585136413574e-001f },
					{ 6.765303611755371094e-001f, 9.712837934494018555e-001f, 5.621681213378906250e-001f,
							-5.318660140037536621e-001f },
					{ 5.385516881942749023e-001f, 8.755537867546081543e-001f, 6.954771280288696289e-001f,
							-6.779964566230773926e-001f },
					{ 2.542968690395355225e-001f, 6.681280732154846191e-001f, 8.420566916465759277e-001f,
							-8.831073045730590820e-001f },
					{ -2.201531976461410522e-001f, 2.771563827991485596e-001f, 8.516213297843933105e-001f,
							-1.072127819061279297e+000f } },
			{
					{ 1.000000000000000000e+000f, 1.000000000000000000e+000f, 0.000000000000000000e+000f,
							0.000000000000000000e+000f },
					{ 9.841240048408508301e-001f, 9.841240048408508301e-001f, 1.774823963642120361e-001f,
							-1.774823963642120361e-001f },
					{ 9.594737887382507324e-001f, 9.594737887382507324e-001f, 2.817977964878082275e-001f,
							-2.817977964878082275e-001f },
					{ 8.946843147277832031e-001f, 8.946843147277832031e-001f, 4.466989934444427490e-001f,
							-4.466989934444427490e-001f },
					{ 8.269340991973876953e-001f, 8.269340991973876953e-001f, 5.622988343238830566e-001f,
							-5.622988343238830566e-001f },
					{ 7.071067690849304199e-001f, 7.071067690849304199e-001f, 7.071067690849304199e-001f,
							-7.071067690849304199e-001f },
					{ 4.533211290836334229e-001f, 4.533211290836334229e-001f, 8.913472890853881836e-001f,
							-8.913472890853881836e-001f },
					{ -4.371138828673792887e-008f, -4.371138828673792887e-008f, 1.000000000000000000e+000f,
							-1.000000000000000000e+000f } },
			{
					{ 1.107372403144836426e+000f, 8.796171545982360840e-001f, 0.000000000000000000e+000f,
							-0.000000000000000000e+000f },
					{ 1.094988703727722168e+000f, 8.608095049858093262e-001f, 1.651468127965927124e-001f,
							-1.809234470129013062e-001f },
					{ 1.075721979141235352e+000f, 8.316769599914550781e-001f, 2.628610730171203613e-001f,
							-2.864258289337158203e-001f },
					{ 1.024850845336914062e+000f, 7.555164694786071777e-001f, 4.194690585136413574e-001f,
							-4.504677951335906982e-001f },
					{ 9.712837934494018555e-001f, 6.765303611755371094e-001f, 5.318660140037536621e-001f,
							-5.621681213378906250e-001f },
					{ 8.755537867546081543e-001f, 5.385516881942749023e-001f, 6.779964566230773926e-001f,
							-6.954771280288696289e-001f },
					{ 6.681280732154846191e-001f, 2.542969882488250732e-001f, 8.831073045730590820e-001f,
							-8.420566320419311523e-001f },
					{ 2.771563827991485596e-001f, -2.201531976461410522e-001f, 1.072127819061279297e+000f,
							-8.516213297843933105e-001f } },
			{
					{ 1.196037411689758301e+000f, 7.546485662460327148e-001f, 0.000000000000000000e+000f,
							-0.000000000000000000e+000f },
					{ 1.187039732933044434e+000f, 7.340614795684814453e-001f, 1.464318335056304932e-001f,
							-1.750661581754684448e-001f },
					{ 1.173018932342529297e+000f, 7.022541165351867676e-001f, 2.335211783647537231e-001f,
							-2.762853205204010010e-001f },
					{ 1.135867953300476074e+000f, 6.195813417434692383e-001f, 3.745791316032409668e-001f,
							-4.308287203311920166e-001f },
					{ 1.096537113189697266e+000f, 5.346060395240783691e-001f, 4.776105284690856934e-001f,
							-5.326263308525085449e-001f },
					{ 1.025686621665954590e+000f, 3.881656229496002197e-001f, 6.152011156082153320e-001f,
							-6.471645236015319824e-001f },
					{ 8.694874644279479980e-001f, 9.563651680946350098e-002f, 8.212776780128479004e-001f,
							-7.485640645027160645e-001f },
					{ 5.631602406501770020e-001f, -3.553301393985748291e-001f, 1.055156826972961426e+000f,
							-6.657589077949523926e-001f } },
			{
					{ 1.264310002326965332e+000f, 6.336560845375061035e-001f, 0.000000000000000000e+000f,
							-0.000000000000000000e+000f },
					{ 1.258136868476867676e+000f, 6.126841902732849121e-001f, 1.247857734560966492e-001f,
							-1.616729199886322021e-001f },
					{ 1.248506546020507812e+000f, 5.803641676902770996e-001f, 1.992766410112380981e-001f,
							-2.543570101261138916e-001f },
					{ 1.222924232482910156e+000f, 4.968406558036804199e-001f, 3.208367824554443359e-001f,
							-3.932802975177764893e-001f },
					{ 1.195736169815063477e+000f, 4.117560684680938721e-001f, 4.107245802879333496e-001f,
							-4.816398620605468750e-001f },
					{ 1.146480679512023926e+000f, 2.671199738979339600e-001f, 5.329744815826416016e-001f,
							-5.746015906333923340e-001f },
					{ 1.036551833152770996e+000f, -1.278852112591266632e-002f, 7.239060997962951660e-001f,
							-6.335270404815673828e-001f },
					{ 8.149553537368774414e-001f, -4.084453284740447998e-001f, 9.666061997413635254e-001f,
							-4.844506382942199707e-001f } },
			{
					{ 1.313920140266418457e+000f, 5.230810642242431641e-001f, 0.000000000000000000e+000f,
							-0.000000000000000000e+000f },
					{ 1.309858441352844238e+000f, 5.029684901237487793e-001f, 1.032327041029930115e-001f,
							-1.436541825532913208e-001f },
					{ 1.303517222404479980e+000f, 4.720451235771179199e-001f, 1.650119125843048096e-001f,
							-2.253601402044296265e-001f },
					{ 1.286643147468566895e+000f, 3.925557434558868408e-001f, 2.663372457027435303e-001f,
							-3.457076549530029297e-001f },
					{ 1.268663287162780762e+000f, 3.122536540031433105e-001f, 3.418764472007751465e-001f,
							-4.196563661098480225e-001f },
					{ 1.235965013504028320e+000f, 1.774936020374298096e-001f, 4.458438456058502197e-001f,
							-4.920465648174285889e-001f },
					{ 1.162387609481811523e+000f, -7.548458129167556763e-002f, 6.125693917274475098e-001f,
							-5.176059007644653320e-001f },
					{ 1.011349678039550781e+000f, -4.026256203651428223e-001f, 8.387836217880249023e-001f,
							-3.339257538318634033e-001f } },
			{
					{ 1.348399758338928223e+000f, 4.264014065265655518e-001f, 0.000000000000000000e+000f,
							-0.000000000000000000e+000f },
					{ 1.345800518989562988e+000f, 4.080123007297515869e-001f, 8.368386328220367432e-002f,
							-1.238714158535003662e-001f },
					{ 1.341740369796752930e+000f, 3.797967135906219482e-001f, 1.338454335927963257e-001f,
							-1.938365399837493896e-001f },
					{ 1.330924391746520996e+000f, 3.076064586639404297e-001f, 2.163843214511871338e-001f,
							-2.952904105186462402e-001f },
					{ 1.319380164146423340e+000f, 2.352139204740524292e-001f, 2.782405912876129150e-001f,
							-3.556579351425170898e-001f },
					{ 1.298333764076232910e+000f, 1.151135340332984924e-001f, 3.640210032463073730e-001f,
							-4.105691611766815186e-001f },
					{ 1.250724673271179199e+000f, -1.041954830288887024e-001f, 5.038547515869140625e-001f,
							-4.134748578071594238e-001f },
					{ 1.151853799819946289e+000f, -3.642481267452239990e-001f, 7.010098695755004883e-001f,
							-2.216787487268447876e-001f } },
			{
					{ 1.380053043365478516e+000f, 3.089554011821746826e-001f, 0.000000000000000000e+000f,
							-0.000000000000000000e+000f },
					{ 1.378760099411010742e+000f, 2.938907146453857422e-001f, 5.972388014197349548e-002f,
							-9.529791027307510376e-002f },
					{ 1.376739740371704102e+000f, 2.708331942558288574e-001f, 9.557281434535980225e-002f,
							-1.486701816320419312e-001f },
					{ 1.371352314949035645e+000f, 2.121736705303192139e-001f, 1.547235399484634399e-001f,
							-2.245790958404541016e-001f },
					{ 1.365593910217285156e+000f, 1.538765728473663330e-001f, 1.992480605840682983e-001f,
							-2.679093778133392334e-001f },
					{ 1.355073571205139160e+000f, 5.851671472191810608e-002f, 2.613846063613891602e-001f,
							-3.033632040023803711e-001f },
					{ 1.331169128417968750e+000f, -1.096648275852203369e-001f, 3.640536367893218994e-001f,
							-2.888374328613281250e-001f },
					{ 1.281039595603942871e+000f, -2.867890596389770508e-001f, 5.133069157600402832e-001f,
							-1.149150878190994263e-001f } },
			{
					{ 1.396779537200927734e+000f, 2.213746309280395508e-001f, 0.000000000000000000e+000f,
							-0.000000000000000000e+000f },
					{ 1.396145582199096680e+000f, 2.096635550260543823e-001f, 4.207841679453849792e-002f,
							-7.104872912168502808e-002f },
					{ 1.395154714584350586e+000f, 1.917716860771179199e-001f, 6.735271215438842773e-002f,
							-1.105909049510955811e-001f },
					{ 1.392511367797851562e+000f, 1.464443653821945190e-001f, 1.091111600399017334e-001f,
							-1.660143882036209106e-001f },
					{ 1.389683961868286133e+000f, 1.016974151134490967e-001f, 1.406111270189285278e-001f,
							-1.966325640678405762e-001f },
					{ 1.384513258934020996e+000f, 2.927377633750438690e-002f, 1.847051233053207397e-001f,
							-2.194305658340454102e-001f },
					{ 1.372738838195800781e+000f, -9.509638696908950806e-002f, 2.580333054065704346e-001f,
							-1.999084949493408203e-001f },
					{ 1.347930073738098145e+000f, -2.136325091123580933e-001f, 3.661661744117736816e-001f,
							-5.803339928388595581e-002f } },
			{
					{ 1.405394792556762695e+000f, 1.576878875494003296e-001f, 0.000000000000000000e+000f,
							-0.000000000000000000e+000f },
					{ 1.405084729194641113e+000f, 1.488780677318572998e-001f, 2.952196076512336731e-002f,
							-5.196911841630935669e-002f },
					{ 1.404599905014038086e+000f, 1.354363113641738892e-001f, 4.726000130176544189e-002f,
							-8.076183497905731201e-002f },
					{ 1.403306484222412109e+000f, 1.014855280518531799e-001f, 7.658588141202926636e-002f,
							-1.206903383135795593e-001f },
					{ 1.401922583580017090e+000f, 6.813107430934906006e-002f, 9.873023629188537598e-002f,
							-1.422097980976104736e-001f },
					{ 1.399390339851379395e+000f, 1.456081587821245193e-002f, 1.297734379768371582e-001f,
							-1.570141762495040894e-001f },
					{ 1.393618106842041016e+000f, -7.563733309507369995e-002f, 1.815574616193771362e-001f,
							-1.383635252714157104e-001f },
					{ 1.381428360939025879e+000f, -1.549988090991973877e-001f, 2.584379911422729492e-001f,
							-2.899721264839172363e-002f } },
			{
					{ 1.409772992134094238e+000f, 1.119822487235069275e-001f, 0.000000000000000000e+000f,
							-0.000000000000000000e+000f },
					{ 1.409620881080627441e+000f, 1.054906323552131653e-001f, 2.070707827806472778e-002f,
							-3.757327049970626831e-002f },
					{ 1.409383177757263184e+000f, 9.559512883424758911e-002f, 3.315071016550064087e-002f,
							-5.832320079207420349e-002f },
					{ 1.408748745918273926e+000f, 7.065486907958984375e-002f, 5.372989177703857422e-002f,
							-8.687873184680938721e-002f },
					{ 1.408069849014282227e+000f, 4.623692482709884644e-002f, 6.927720457315444946e-002f,
							-1.019910350441932678e-001f },
					{ 1.406827211380004883e+000f, 7.235344499349594116e-003f, 9.108766168355941772e-002f,
							-1.117482632398605347e-001f },
					{ 1.403993368148803711e+000f, -5.750105157494544983e-002f, 1.275242418050765991e-001f,
							-9.609190374612808228e-002f },
					{ 1.398002386093139648e+000f, -1.110472753643989563e-001f, 1.817946732044219971e-001f,
							-1.444045267999172211e-002f } },
			{
					{ 1.411982774734497070e+000f, 7.940161973237991333e-002f, 0.000000000000000000e+000f,
							-0.000000000000000000e+000f },
					{ 1.411907911300659180e+000f, 7.468104362487792969e-002f, 1.454224810004234314e-002f,
							-2.696959488093852997e-002f },
					{ 1.411790847778320312e+000f, 6.748995184898376465e-002f, 2.328187786042690277e-002f,
							-4.182969778776168823e-002f },
					{ 1.411478400230407715e+000f, 4.939322173595428467e-002f, 3.773759678006172180e-002f,
							-6.216853484511375427e-002f },
					{ 1.411144018173217773e+000f, 3.171866387128829956e-002f, 4.866134002804756165e-002f,
							-7.279109209775924683e-002f },
					{ 1.410531997680664062e+000f, 3.598468611016869545e-003f, 6.399089843034744263e-002f,
							-7.932003587484359741e-002f },
					{ 1.409135818481445312e+000f, -4.260054230690002441e-002f, 8.961889147758483887e-002f,
							-6.700605154037475586e-002f },
					{ 1.406182646751403809e+000f, -7.907545566558837891e-002f, 1.278502941131591797e-001f,
							-7.189542986452579498e-003f } },
			{
					{ 1.413506984710693359e+000f, 4.469901695847511292e-002f, 0.000000000000000000e+000f,
							-0.000000000000000000e+000f },
					{ 1.413483738899230957e+000f, 4.197174310684204102e-002f, 8.097534999251365662e-003f,
							-1.537448819726705551e-002f },
					{ 1.413447499275207520e+000f, 3.782002627849578857e-002f, 1.296425517648458481e-002f,
							-2.382535673677921295e-002f },
					{ 1.413350701332092285e+000f, 2.738874219357967377e-002f, 2.101483382284641266e-002f,
							-3.532504662871360779e-002f },
					{ 1.413247227668762207e+000f, 1.722707040607929230e-002f, 2.709938772022724152e-002f,
							-4.124597087502479553e-002f },
					{ 1.413057565689086914e+000f, 1.127029536291956902e-003f, 3.563993796706199646e-002f,
							-4.468480497598648071e-002f },
					{ 1.412625074386596680e+000f, -2.503543905913829803e-002f, 4.992490634322166443e-002f,
							-3.703010827302932739e-002f },
					{ 1.411709785461425781e+000f, -4.464218392968177795e-002f, 7.125721871852874756e-002f,
							-2.253342652693390846e-003f } },
			{
					{ 1.413990020751953125e+000f, 2.514469437301158905e-002f, 0.000000000000000000e+000f,
							-0.000000000000000000e+000f },
					{ 1.413982748985290527e+000f, 2.358857169747352600e-002f, 4.525675904005765915e-003f,
							-8.708326146006584167e-003f },
					{ 1.413971424102783203e+000f, 2.122061140835285187e-002f, 7.245706859976053238e-003f,
							-1.348856091499328613e-002f },
					{ 1.413941264152526855e+000f, 1.527637615799903870e-002f, 1.174534857273101807e-002f,
							-1.997218094766139984e-002f },
					{ 1.413908839225769043e+000f, 9.494148194789886475e-003f, 1.514630671590566635e-002f,
							-2.328340150415897369e-002f },
					{ 1.413849711418151855e+000f, 3.542384947650134563e-004f, 1.992037892341613770e-002f,
							-2.514219842851161957e-002f },
					{ 1.413714647293090820e+000f, -1.440629363059997559e-002f, 2.790668979287147522e-002f,
							-2.060860022902488708e-002f },
					{ 1.413428783416748047e+000f, -2.513471245765686035e-002f, 3.983680158853530884e-002f,
							-7.084066746756434441e-004f } },
			{
					{ 1.414142847061157227e+000f, 1.414142828434705734e-002f, 0.000000000000000000e+000f,
							-0.000000000000000000e+000f },
					{ 1.414140582084655762e+000f, 1.325935497879981995e-002f, 2.535717561841011047e-003f,
							-4.916248377412557602e-003f },
					{ 1.414137005805969238e+000f, 1.191739086061716080e-002f, 4.059746861457824707e-003f,
							-7.612869609147310257e-003f },
					{ 1.414127588272094727e+000f, 8.550377562642097473e-003f, 6.580914370715618134e-003f,
							-1.126370485872030258e-002f },
					{ 1.414117336273193359e+000f, 5.277783609926700592e-003f, 8.486513979732990265e-003f,
							-1.311964169144630432e-002f },
					{ 1.414098739624023438e+000f, 1.116160419769585133e-004f, 1.116154622286558151e-002f,
							-1.414098776876926422e-002f },
					{ 1.414056420326232910e+000f, -8.202425204217433929e-003f, 1.563668064773082733e-002f,
							-1.151955779641866684e-002f },
					{ 1.413966655731201172e+000f, -1.413966622203588486e-002f, 2.232239767909049988e-002f,
							-2.232251281384378672e-004f } },
			{
					{ 1.414191126823425293e+000f, 7.952581159770488739e-003f, 0.000000000000000000e+000f,
							-0.000000000000000000e+000f },
					{ 1.414190411567687988e+000f, 7.454359903931617737e-003f, 1.422943081706762314e-003f,
							-2.770571038126945496e-003f },
					{ 1.414189338684082031e+000f, 6.696471013128757477e-003f, 2.278168685734272003e-003f,
							-4.289617761969566345e-003f },
					{ 1.414186358451843262e+000f, 4.795448388904333115e-003f, 3.692953381687402725e-003f,
							-6.344069726765155792e-003f },
					{ 1.414183139801025391e+000f, 2.948575653135776520e-003f, 4.762309603393077850e-003f,
							-7.385760080069303513e-003f },
					{ 1.414177298545837402e+000f, 3.522138285916298628e-005f, 6.263454444706439972e-003f,
							-7.952502928674221039e-003f },
					{ 1.414163947105407715e+000f, -4.644102882593870163e-003f, 8.774798363447189331e-003f,
							-6.455684080719947815e-003f },
					{ 1.414135694503784180e+000f, -7.952269166707992554e-003f, 1.252678595483303070e-002f,
							-7.044207450235262513e-005f } },
			{
					{ 1.414206504821777344e+000f, 4.472113680094480515e-003f, 0.000000000000000000e+000f,
							-0.000000000000000000e+000f },
					{ 1.414206266403198242e+000f, 4.191252868622541428e-003f, 7.992122555151581764e-004f,
							-1.559872296638786793e-003f },
					{ 1.414205908775329590e+000f, 3.764039138332009315e-003f, 1.279559684917330742e-003f,
							-2.414914080873131752e-003f },
					{ 1.414204955101013184e+000f, 2.692622598260641098e-003f, 2.074191113933920860e-003f,
							-3.570656059309840202e-003f },
					{ 1.414204001426696777e+000f, 1.651991158723831177e-003f, 2.674809191375970840e-003f,
							-4.155806265771389008e-003f },
					{ 1.414202094078063965e+000f, 1.112435620598262176e-005f, 3.517948556691408157e-003f,
							-4.472099710255861282e-003f },
					{ 1.414197921752929688e+000f, -2.621463732793927193e-003f, 4.928487353026866913e-003f,
							-3.623220836743712425e-003f },
					{ 1.414188981056213379e+000f, -4.472058266401290894e-003f, 7.035875227302312851e-003f,
							-2.224864329036790878e-005f } } };
	float[][][] HB = {
			{
					{ 7.940160483121871948e-002f, 1.411982774734497070e+000f, -0.000000000000000000e+000f,
							0.000000000000000000e+000f },
					{ 7.442792505025863647e-002f, 1.411982059478759766e+000f, -2.766048349440097809e-002f,
							1.458030077628791332e-003f },
					{ 6.685267388820648193e-002f, 1.411981344223022461e+000f, -4.284084960818290710e-002f,
							2.028373302891850471e-003f },
					{ 4.781049489974975586e-002f, 1.411981105804443359e+000f, -6.339383125305175781e-002f,
							2.146551851183176041e-003f },
					{ 2.927117794752120972e-002f, 1.411981940269470215e+000f, -7.380931079387664795e-002f,
							1.530108391307294369e-003f },
					{ 3.982603084295988083e-003f, 1.411982774734497070e+000f, -7.930168509483337402e-002f,
							2.236763248220086098e-004f },
					{ 3.982603084295988083e-003f, 1.411982774734497070e+000f, -7.930168509483337402e-002f,
							2.236763248220086098e-004f },
					{ 3.982603084295988083e-003f, 1.411982774734497070e+000f, -7.930168509483337402e-002f,
							2.236763248220086098e-004f } },
			{
					{ 1.766446530818939209e-001f, 1.403138160705566406e+000f, -0.000000000000000000e+000f,
							0.000000000000000000e+000f },
					{ 1.658301800489425659e-001f, 1.403119683265686035e+000f, -6.085789948701858521e-002f,
							7.192598655819892883e-003f },
					{ 1.492701470851898193e-001f, 1.403102159500122070e+000f, -9.445490688085556030e-002f,
							1.004866044968366623e-002f },
					{ 1.072256490588188171e-001f, 1.403097152709960938e+000f, -1.403779685497283936e-001f,
							1.072778087109327316e-002f },
					{ 6.584122031927108765e-002f, 1.403117060661315918e+000f, -1.639153957366943359e-001f,
							7.691725157201290131e-003f },
					{ 8.974105119705200195e-003f, 1.403137683868408203e+000f, -1.764165014028549194e-001f,
							1.128314295783638954e-003f },
					{ 8.974105119705200195e-003f, 1.403137683868408203e+000f, -1.764165014028549194e-001f,
							1.128314295783638954e-003f },
					{ 8.974105119705200195e-003f, 1.403137683868408203e+000f, -1.764165014028549194e-001f,
							1.128314295783638954e-003f } },
			{
					{ 2.767183482646942139e-001f, 1.386876702308654785e+000f, -0.000000000000000000e+000f,
							0.000000000000000000e+000f },
					{ 2.604868710041046143e-001f, 1.386765837669372559e+000f, -9.337889403104782104e-002f,
							1.754007488489151001e-002f },
					{ 2.353973984718322754e-001f, 1.386656761169433594e+000f, -1.454684436321258545e-001f,
							2.469456940889358521e-002f },
					{ 1.705288887023925781e-001f, 1.386617660522460938e+000f, -2.179286926984786987e-001f,
							2.680128812789916992e-002f },
					{ 1.053290367126464844e-001f, 1.386740446090698242e+000f, -2.558882534503936768e-001f,
							1.943583786487579346e-002f },
					{ 1.440798584371805191e-002f, 1.386873841285705566e+000f, -2.763429284095764160e-001f,
							2.870877739042043686e-003f },
					{ 1.440798584371805191e-002f, 1.386873841285705566e+000f, -2.763429284095764160e-001f,
							2.870877739042043686e-003f },
					{ 1.440798584371805191e-002f, 1.386873841285705566e+000f, -2.763429284095764160e-001f,
							2.870877739042043686e-003f } },
			{
					{ 4.264014065265655518e-001f, 1.348399758338928223e+000f, -0.000000000000000000e+000f,
							0.000000000000000000e+000f },
					{ 4.038802087306976318e-001f, 1.347776889801025391e+000f, -1.367439776659011841e-001f,
							4.097724705934524536e-002f },
					{ 3.683817684650421143e-001f, 1.347120404243469238e+000f, -2.147395908832550049e-001f,
							5.872240662574768066e-002f },
					{ 2.726995944976806641e-001f, 1.346765041351318359e+000f, -3.278003931045532227e-001f,
							6.637462973594665527e-002f },
					{ 1.712507456541061401e-001f, 1.347486138343811035e+000f, -3.905014097690582275e-001f,
							4.962845891714096069e-002f },
					{ 2.368136495351791382e-002f, 1.348379015922546387e+000f, -4.257433116436004639e-001f,
							7.477261591702699661e-003f },
					{ 2.368136495351791382e-002f, 1.348379015922546387e+000f, -4.257433116436004639e-001f,
							7.477261591702699661e-003f },
					{ 2.368136495351791382e-002f, 1.348379015922546387e+000f, -4.257433116436004639e-001f,
							7.477261591702699661e-003f } },
			{
					{ 5.767799019813537598e-001f, 1.291249394416809082e+000f, -0.000000000000000000e+000f,
							0.000000000000000000e+000f },
					{ 5.509595870971679688e-001f, 1.289188385009765625e+000f, -1.706415563821792603e-001f,
							7.292697578668594360e-002f },
					{ 5.093750953674316406e-001f, 1.286799550056457520e+000f, -2.705773115158081055e-001f,
							1.071070805191993713e-001f },
					{ 3.909356892108917236e-001f, 1.284785389900207520e+000f, -4.240806400775909424e-001f,
							1.290396600961685181e-001f },
					{ 2.538059055805206299e-001f, 1.287204504013061523e+000f, -5.179359316825866699e-001f,
							1.021245568990707397e-001f },
					{ 3.599660471081733704e-002f, 1.291149616241455078e+000f, -5.756555199623107910e-001f,
							1.604898832738399506e-002f },
					{ 3.599660471081733704e-002f, 1.291149616241455078e+000f, -5.756555199623107910e-001f,
							1.604898832738399506e-002f },
					{ 3.599660471081733704e-002f, 1.291149616241455078e+000f, -5.756555199623107910e-001f,
							1.604898832738399506e-002f } },
			{
					{ 7.546485662460327148e-001f, 1.196037411689758301e+000f, -0.000000000000000000e+000f,
							0.000000000000000000e+000f },
					{ 7.296715378761291504e-001f, 1.190198063850402832e+000f, -1.925457268953323364e-001f,
							1.180435046553611755e-001f },
					{ 6.888567209243774414e-001f, 1.182487130165100098e+000f, -3.081735670566558838e-001f,
							1.795261949300765991e-001f },
					{ 5.658041238784790039e-001f, 1.171467185020446777e+000f, -4.993597567081451416e-001f,
							2.411845624446868896e-001f },
					{ 4.006332457065582275e-001f, 1.176027655601501465e+000f, -6.395213007926940918e-001f,
							2.178635001182556152e-001f },
					{ 6.248449534177780151e-002f, 1.195391178131103516e+000f, -7.520573139190673828e-001f,
							3.931091353297233582e-002f },
					{ 6.248449534177780151e-002f, 1.195391178131103516e+000f, -7.520573139190673828e-001f,
							3.931091353297233582e-002f },
					{ 6.248449534177780151e-002f, 1.195391178131103516e+000f, -7.520573139190673828e-001f,
							3.931091353297233582e-002f } },
			{
					{ 8.796170949935913086e-001f, 1.107372403144836426e+000f, -0.000000000000000000e+000f,
							0.000000000000000000e+000f },
					{ 8.583186864852905273e-001f, 1.097094893455505371e+000f, -1.923940330743789673e-001f,
							1.505206078290939331e-001f },
					{ 8.238825798034667969e-001f, 1.082243204116821289e+000f, -3.081296980381011963e-001f,
							2.345708459615707397e-001f },
					{ 7.213549613952636719e-001f, 1.052233219146728516e+000f, -5.033620595932006836e-001f,
							3.450781702995300293e-001f },
					{ 5.758311152458190918e-001f, 1.044997930526733398e+000f, -6.649397015571594238e-001f,
							3.664054572582244873e-001f },
					{ 1.174122542142868042e-001f, 1.103480935096740723e+000f, -8.717458248138427734e-001f,
							9.275524318218231201e-002f },
					{ 1.174122542142868042e-001f, 1.103480935096740723e+000f, -8.717458248138427734e-001f,
							9.275524318218231201e-002f },
					{ 1.174122542142868042e-001f, 1.103480935096740723e+000f, -8.717458248138427734e-001f,
							9.275524318218231201e-002f } },
			{
					{ 1.000000000000000000e+000f, 1.000000000000000000e+000f, -0.000000000000000000e+000f,
							0.000000000000000000e+000f },
					{ 9.841239452362060547e-001f, 9.841239452362060547e-001f, -1.774824261665344238e-001f,
							1.774824261665344238e-001f },
					{ 9.594738483428955078e-001f, 9.594738483428955078e-001f, -2.817977666854858398e-001f,
							2.817977666854858398e-001f },
					{ 8.946843147277832031e-001f, 8.946843147277832031e-001f, -4.466989934444427490e-001f,
							4.466989934444427490e-001f },
					{ 8.269340991973876953e-001f, 8.269340991973876953e-001f, -5.622988939285278320e-001f,
							5.622988939285278320e-001f },
					{ 7.245688438415527344e-001f, 7.245688438415527344e-001f, -6.892024278640747070e-001f,
							6.892024278640747070e-001f },
					{ 7.245688438415527344e-001f, 7.245688438415527344e-001f, -6.892024278640747070e-001f,
							6.892024278640747070e-001f },
					{ 7.245688438415527344e-001f, 7.245688438415527344e-001f, -6.892024278640747070e-001f,
							6.892024278640747070e-001f } },
			{
					{ 1.107372403144836426e+000f, 8.796170949935913086e-001f, -0.000000000000000000e+000f,
							0.000000000000000000e+000f },
					{ 1.097094893455505371e+000f, 8.583186864852905273e-001f, -1.505206078290939331e-001f,
							1.923940330743789673e-001f },
					{ 1.082243204116821289e+000f, 8.238825798034667969e-001f, -2.345708459615707397e-001f,
							3.081296980381011963e-001f },
					{ 1.052233219146728516e+000f, 7.213549017906188965e-001f, -3.450781404972076416e-001f,
							5.033620595932006836e-001f },
					{ 1.044997930526733398e+000f, 5.758311748504638672e-001f, -3.664054870605468750e-001f,
							6.649397015571594238e-001f },
					{ 1.103480935096740723e+000f, 1.174122393131256104e-001f, -9.275523573160171509e-002f,
							8.717458248138427734e-001f },
					{ 1.103480935096740723e+000f, 1.174122393131256104e-001f, -9.275523573160171509e-002f,
							8.717458248138427734e-001f },
					{ 1.103480935096740723e+000f, 1.174122393131256104e-001f, -9.275523573160171509e-002f,
							8.717458248138427734e-001f } },
			{
					{ 1.196037411689758301e+000f, 7.546485662460327148e-001f, -0.000000000000000000e+000f,
							0.000000000000000000e+000f },
					{ 1.190198063850402832e+000f, 7.296716570854187012e-001f, -1.180435195565223694e-001f,
							1.925457268953323364e-001f },
					{ 1.182487130165100098e+000f, 6.888566017150878906e-001f, -1.795261651277542114e-001f,
							3.081735670566558838e-001f },
					{ 1.171467185020446777e+000f, 5.658041238784790039e-001f, -2.411845624446868896e-001f,
							4.993597567081451416e-001f },
					{ 1.176027655601501465e+000f, 4.006332159042358398e-001f, -2.178634852170944214e-001f,
							6.395213007926940918e-001f },
					{ 1.195391178131103516e+000f, 6.248455122113227844e-002f, -3.931094706058502197e-002f,
							7.520572543144226074e-001f },
					{ 1.195391178131103516e+000f, 6.248455122113227844e-002f, -3.931094706058502197e-002f,
							7.520572543144226074e-001f },
					{ 1.195391178131103516e+000f, 6.248455122113227844e-002f, -3.931094706058502197e-002f,
							7.520572543144226074e-001f } },
			{
					{ 1.291249394416809082e+000f, 5.767799019813537598e-001f, -0.000000000000000000e+000f,
							0.000000000000000000e+000f },
					{ 1.289188385009765625e+000f, 5.509597063064575195e-001f, -7.292698323726654053e-002f,
							1.706415563821792603e-001f },
					{ 1.286799550056457520e+000f, 5.093750357627868652e-001f, -1.071070730686187744e-001f,
							2.705773115158081055e-001f },
					{ 1.284785509109497070e+000f, 3.909355998039245605e-001f, -1.290396302938461304e-001f,
							4.240806698799133301e-001f },
					{ 1.287204504013061523e+000f, 2.538058161735534668e-001f, -1.021245345473289490e-001f,
							5.179359912872314453e-001f },
					{ 1.291149616241455078e+000f, 3.599662333726882935e-002f, -1.604899764060974121e-002f,
							5.756555199623107910e-001f },
					{ 1.291149616241455078e+000f, 3.599662333726882935e-002f, -1.604899764060974121e-002f,
							5.756555199623107910e-001f },
					{ 1.291149616241455078e+000f, 3.599662333726882935e-002f, -1.604899764060974121e-002f,
							5.756555199623107910e-001f } },
			{
					{ 1.348399758338928223e+000f, 4.264014363288879395e-001f, -0.000000000000000000e+000f,
							0.000000000000000000e+000f },
					{ 1.347776889801025391e+000f, 4.038802683353424072e-001f, -4.097725450992584229e-002f,
							1.367439776659011841e-001f },
					{ 1.347120404243469238e+000f, 3.683817386627197266e-001f, -5.872239917516708374e-002f,
							2.147395908832550049e-001f },
					{ 1.346765041351318359e+000f, 2.726996243000030518e-001f, -6.637463718652725220e-002f,
							3.278003931045532227e-001f },
					{ 1.347486138343811035e+000f, 1.712508350610733032e-001f, -4.962848126888275146e-002f,
							3.905014097690582275e-001f },
					{ 1.348379015922546387e+000f, 2.368129603564739227e-002f, -7.477240171283483505e-003f,
							4.257433116436004639e-001f },
					{ 1.348379015922546387e+000f, 2.368129603564739227e-002f, -7.477240171283483505e-003f,
							4.257433116436004639e-001f },
					{ 1.348379015922546387e+000f, 2.368129603564739227e-002f, -7.477240171283483505e-003f,
							4.257433116436004639e-001f } },
			{
					{ 1.386876702308654785e+000f, 2.767182886600494385e-001f, -0.000000000000000000e+000f,
							0.000000000000000000e+000f },
					{ 1.386765837669372559e+000f, 2.604868113994598389e-001f, -1.754006929695606232e-002f,
							9.337888658046722412e-002f },
					{ 1.386656761169433594e+000f, 2.353974133729934692e-001f, -2.469457127153873444e-002f,
							1.454684436321258545e-001f },
					{ 1.386617660522460938e+000f, 1.705288589000701904e-001f, -2.680128067731857300e-002f,
							2.179286777973175049e-001f },
					{ 1.386740565299987793e+000f, 1.053291037678718567e-001f, -1.943584904074668884e-002f,
							2.558882534503936768e-001f },
					{ 1.386873841285705566e+000f, 1.440798398107290268e-002f, -2.870877273380756378e-003f,
							2.763429284095764160e-001f },
					{ 1.386873841285705566e+000f, 1.440798398107290268e-002f, -2.870877273380756378e-003f,
							2.763429284095764160e-001f },
					{ 1.386873841285705566e+000f, 1.440798398107290268e-002f, -2.870877273380756378e-003f,
							2.763429284095764160e-001f } },
			{
					{ 1.403138160705566406e+000f, 1.766446232795715332e-001f, -0.000000000000000000e+000f,
							0.000000000000000000e+000f },
					{ 1.403119683265686035e+000f, 1.658301651477813721e-001f, -7.192598655819892883e-003f,
							6.085790693759918213e-002f },
					{ 1.403102159500122070e+000f, 1.492702066898345947e-001f, -1.004866510629653931e-002f,
							9.445490688085556030e-002f },
					{ 1.403097152709960938e+000f, 1.072256937623023987e-001f, -1.072778645902872086e-002f,
							1.403779685497283936e-001f },
					{ 1.403117060661315918e+000f, 6.584116816520690918e-002f, -7.691720034927129745e-003f,
							1.639154255390167236e-001f },
					{ 1.403137683868408203e+000f, 8.974096737802028656e-003f, -1.128313364461064339e-003f,
							1.764165312051773071e-001f },
					{ 1.403137683868408203e+000f, 8.974096737802028656e-003f, -1.128313364461064339e-003f,
							1.764165312051773071e-001f },
					{ 1.403137683868408203e+000f, 8.974096737802028656e-003f, -1.128313364461064339e-003f,
							1.764165312051773071e-001f } },
			{
					{ 1.411982774734497070e+000f, 7.940161973237991333e-002f, -0.000000000000000000e+000f,
							0.000000000000000000e+000f },
					{ 1.411982059478759766e+000f, 7.442793250083923340e-002f, -1.458030194044113159e-003f,
							2.766048349440097809e-002f },
					{ 1.411981344223022461e+000f, 6.685267388820648193e-002f, -2.028373302891850471e-003f,
							4.284084588289260864e-002f },
					{ 1.411981105804443359e+000f, 4.781045392155647278e-002f, -2.146549988538026810e-003f,
							6.339383125305175781e-002f },
					{ 1.411981940269470215e+000f, 2.927121333777904510e-002f, -1.530110253952443600e-003f,
							7.380931079387664795e-002f },
					{ 1.411982774734497070e+000f, 3.982644062489271164e-003f, -2.236786240246146917e-004f,
							7.930167764425277710e-002f },
					{ 1.411982774734497070e+000f, 3.982644062489271164e-003f, -2.236786240246146917e-004f,
							7.930167764425277710e-002f },
					{ 1.411982774734497070e+000f, 3.982644062489271164e-003f, -2.236786240246146917e-004f,
							7.930167764425277710e-002f } },
			{
					{ 4.472048487514257431e-003f, 1.414206504821777344e+000f, -0.000000000000000000e+000f,
							0.000000000000000000e+000f },
					{ 4.190337844192981720e-003f, 1.414206504821777344e+000f, -1.562227145768702030e-003f,
							4.628927854355424643e-006f },
					{ 3.761787433177232742e-003f, 1.414206504821777344e+000f, -2.418301533907651901e-003f,
							6.432679128920426592e-006f },
					{ 2.687379717826843262e-003f, 1.414206504821777344e+000f, -3.574588568881154060e-003f,
							6.792697149649029598e-006f },
					{ 1.644163508899509907e-003f, 1.414206504821777344e+000f, -4.158917814493179321e-003f,
							4.835178515349980444e-006f },
					{ 2.236525324406102300e-004f, 1.414206504821777344e+000f, -4.466520156711339951e-003f,
							7.063667908369097859e-007f },
					{ 2.236525324406102300e-004f, 1.414206504821777344e+000f, -4.466520156711339951e-003f,
							7.063667908369097859e-007f },
					{ 2.236525324406102300e-004f, 1.414206504821777344e+000f, -4.466520156711339951e-003f,
							7.063667908369097859e-007f } },
			{
					{ 7.952500134706497192e-003f, 1.414191246032714844e+000f, -0.000000000000000000e+000f,
							0.000000000000000000e+000f },
					{ 7.451620884239673615e-003f, 1.414191246032714844e+000f, -2.777993446215987206e-003f,
							1.463773332943674177e-005f },
					{ 6.689598318189382553e-003f, 1.414191126823425293e+000f, -4.300303291529417038e-003f,
							2.034187673416454345e-005f },
					{ 4.778996575623750687e-003f, 1.414191246032714844e+000f, -6.356498226523399353e-003f,
							2.148060593754053116e-005f },
					{ 2.923707477748394012e-003f, 1.414191246032714844e+000f, -7.395616732537746429e-003f,
							1.528974280518013984e-005f },
					{ 3.976295702159404755e-004f, 1.414191126823425293e+000f, -7.942633703351020813e-003f,
							2.233238319604424760e-006f },
					{ 3.976295702159404755e-004f, 1.414191126823425293e+000f, -7.942633703351020813e-003f,
							2.233238319604424760e-006f },
					{ 3.976295702159404755e-004f, 1.414191126823425293e+000f, -7.942633703351020813e-003f,
							2.233238319604424760e-006f } },
			{
					{ 1.414148695766925812e-002f, 1.414142847061157227e+000f, -0.000000000000000000e+000f,
							0.000000000000000000e+000f },
					{ 1.325063314288854599e-002f, 1.414142966270446777e+000f, -4.939583595842123032e-003f,
							4.628429451258853078e-005f },
					{ 1.189582608640193939e-002f, 1.414142847061157227e+000f, -7.646509446203708649e-003f,
							6.432273949030786753e-005f },
					{ 8.498443290591239929e-003f, 1.414142847061157227e+000f, -1.130296476185321808e-002f,
							6.792638305341824889e-005f },
					{ 5.199443083256483078e-003f, 1.414142966270446777e+000f, -1.315090060234069824e-002f,
							4.835250729229301214e-005f },
					{ 7.071270374581217766e-004f, 1.414142847061157227e+000f, -1.412373594939708710e-002f,
							7.062423264869721606e-006f },
					{ 7.071270374581217766e-004f, 1.414142847061157227e+000f, -1.412373594939708710e-002f,
							7.062423264869721606e-006f },
					{ 7.071270374581217766e-004f, 1.414142847061157227e+000f, -1.412373594939708710e-002f,
							7.062423264869721606e-006f } },
			{
					{ 2.514477260410785675e-002f, 1.413990020751953125e+000f, -0.000000000000000000e+000f,
							0.000000000000000000e+000f },
					{ 2.356151677668094635e-002f, 1.413989901542663574e+000f, -8.781343698501586914e-003f,
							1.463247754145413637e-004f },
					{ 2.115319296717643738e-002f, 1.413990020751953125e+000f, -1.359408162534236908e-002f,
							2.033665223279967904e-004f },
					{ 1.511299610137939453e-002f, 1.413990020751953125e+000f, -2.009608969092369080e-002f,
							2.147908526239916682e-004f },
					{ 9.246806614100933075e-003f, 1.413989901542663574e+000f, -2.338276430964469910e-002f,
							1.529119035694748163e-004f },
					{ 1.257570227608084679e-003f, 1.413990020751953125e+000f, -2.511322312057018280e-002f,
							2.233512350358068943e-005f },
					{ 1.257570227608084679e-003f, 1.413990020751953125e+000f, -2.511322312057018280e-002f,
							2.233512350358068943e-005f },
					{ 1.257570227608084679e-003f, 1.413990020751953125e+000f, -2.511322312057018280e-002f,
							2.233512350358068943e-005f } },
			{
					{ 4.469900205731391907e-002f, 1.413506984710693359e+000f, -0.000000000000000000e+000f,
							0.000000000000000000e+000f },
					{ 4.188809171319007874e-002f, 1.413506865501403809e+000f, -1.560098025947809219e-002f,
							4.623219720087945461e-004f },
					{ 3.761096298694610596e-002f, 1.413506865501403809e+000f, -2.415412478148937225e-002f,
							6.426993058994412422e-004f },
					{ 2.687774412333965302e-002f, 1.413506865501403809e+000f, -3.571541979908943176e-002f,
							6.791264750063419342e-004f },
					{ 1.644743047654628754e-002f, 1.413506865501403809e+000f, -4.156303405761718750e-002f,
							4.836235020775347948e-004f },
					{ 2.237156732007861137e-003f, 1.413506984710693359e+000f, -4.464299231767654419e-002f,
							7.065643876558169723e-005f },
					{ 2.237156732007861137e-003f, 1.413506984710693359e+000f, -4.464299231767654419e-002f,
							7.065643876558169723e-005f },
					{ 2.237156732007861137e-003f, 1.413506984710693359e+000f, -4.464299231767654419e-002f,
							7.065643876558169723e-005f } },
			{
					{ 7.940160483121871948e-002f, 1.411982774734497070e+000f, -0.000000000000000000e+000f,
							0.000000000000000000e+000f },
					{ 7.442792505025863647e-002f, 1.411982059478759766e+000f, -2.766048349440097809e-002f,
							1.458030077628791332e-003f },
					{ 6.685267388820648193e-002f, 1.411981344223022461e+000f, -4.284084960818290710e-002f,
							2.028373302891850471e-003f },
					{ 4.781049489974975586e-002f, 1.411981105804443359e+000f, -6.339383125305175781e-002f,
							2.146551851183176041e-003f },
					{ 2.927117794752120972e-002f, 1.411981940269470215e+000f, -7.380931079387664795e-002f,
							1.530108391307294369e-003f },
					{ 3.982603084295988083e-003f, 1.411982774734497070e+000f, -7.930168509483337402e-002f,
							2.236763248220086098e-004f },
					{ 3.982603084295988083e-003f, 1.411982774734497070e+000f, -7.930168509483337402e-002f,
							2.236763248220086098e-004f },
					{ 3.982603084295988083e-003f, 1.411982774734497070e+000f, -7.930168509483337402e-002f,
							2.236763248220086098e-004f } },
			{
					{ 1.119822487235069275e-001f, 1.409773111343383789e+000f, -0.000000000000000000e+000f,
							0.000000000000000000e+000f },
					{ 1.050075367093086243e-001f, 1.409770131111145020e+000f, -3.890294209122657776e-002f,
							2.897707978263497353e-003f },
					{ 9.437011182308197021e-002f, 1.409767270088195801e+000f, -6.028509512543678284e-002f,
							4.035496618598699570e-003f },
					{ 6.756372749805450439e-002f, 1.409766554832458496e+000f, -8.930373191833496094e-002f,
							4.279923625290393829e-003f },
					{ 4.139467701315879822e-002f, 1.409769654273986816e+000f, -1.040504649281501770e-001f,
							3.055205103009939194e-003f },
					{ 5.634617991745471954e-003f, 1.409772872924804688e+000f, -1.118403971195220947e-001f,
							4.470066633075475693e-004f },
					{ 5.634617991745471954e-003f, 1.409772872924804688e+000f, -1.118403971195220947e-001f,
							4.470066633075475693e-004f },
					{ 5.634617991745471954e-003f, 1.409772872924804688e+000f, -1.118403971195220947e-001f,
							4.470066633075475693e-004f } },
			{
					{ 1.576879769563674927e-001f, 1.405394792556762695e+000f, -0.000000000000000000e+000f,
							0.000000000000000000e+000f },
					{ 1.479770988225936890e-001f, 1.405383110046386719e+000f, -5.448146536946296692e-002f,
							5.736520513892173767e-003f },
					{ 1.331275254487991333e-001f, 1.405372023582458496e+000f, -8.451355993747711182e-002f,
							8.005767129361629486e-003f },
					{ 9.552083164453506470e-002f, 1.405368924140930176e+000f, -1.254640817642211914e-001f,
							8.527606725692749023e-003f },
					{ 5.860881134867668152e-002f, 1.405381560325622559e+000f, -1.463915109634399414e-001f,
							6.104984320700168610e-003f },
					{ 7.984626106917858124e-003f, 1.405394434928894043e+000f, -1.574856042861938477e-001f,
							8.947406895458698273e-004f },
					{ 7.984626106917858124e-003f, 1.405394434928894043e+000f, -1.574856042861938477e-001f,
							8.947406895458698273e-004f },
					{ 7.984626106917858124e-003f, 1.405394434928894043e+000f, -1.574856042861938477e-001f,
							8.947406895458698273e-004f } },
			{
					{ 2.213746309280395508e-001f, 1.396779656410217285e+000f, -0.000000000000000000e+000f,
							0.000000000000000000e+000f },
					{ 2.080452144145965576e-001f, 1.396734118461608887e+000f, -7.565663754940032959e-002f,
							1.126914750784635544e-002f },
					{ 1.875574588775634766e-001f, 1.396690368652343750e+000f, -1.175965219736099243e-001f,
							1.579169183969497681e-002f },
					{ 1.351681202650070190e-001f, 1.396676421165466309e+000f, -1.753177940845489502e-001f,
							1.696697622537612915e-002f },
					{ 8.318393677473068237e-002f, 1.396726131439208984e+000f, -2.051515877246856689e-001f,
							1.221808418631553650e-002f },
					{ 1.135310344398021698e-002f, 1.396778464317321777e+000f, -2.210833281278610229e-001f,
							1.796979224309325218e-003f },
					{ 1.135310344398021698e-002f, 1.396778464317321777e+000f, -2.210833281278610229e-001f,
							1.796979224309325218e-003f },
					{ 1.135310344398021698e-002f, 1.396778464317321777e+000f, -2.210833281278610229e-001f,
							1.796979224309325218e-003f } },
			{
					{ 3.089554309844970703e-001f, 1.380053162574768066e+000f, -0.000000000000000000e+000f,
							0.000000000000000000e+000f },
					{ 2.911602854728698730e-001f, 1.379880905151367188e+000f, -1.033397167921066284e-001f,
							2.180508710443973541e-002f },
					{ 2.635508179664611816e-001f, 1.379709482192993164e+000f, -1.612279266119003296e-001f,
							3.079761005938053131e-002f },
					{ 1.916256099939346313e-001f, 1.379642605781555176e+000f, -2.423490136861801147e-001f,
							3.366109356284141541e-002f },
					{ 1.186741068959236145e-001f, 1.379835009574890137e+000f, -2.852540612220764160e-001f,
							2.453356422483921051e-002f },
					{ 1.626048982143402100e-002f, 1.380048274993896484e+000f, -3.085272014141082764e-001f,
							3.635237459093332291e-003f },
					{ 1.626048982143402100e-002f, 1.380048274993896484e+000f, -3.085272014141082764e-001f,
							3.635237459093332291e-003f },
					{ 1.626048982143402100e-002f, 1.380048274993896484e+000f, -3.085272014141082764e-001f,
							3.635237459093332291e-003f } },
			{
					{ 4.264014065265655518e-001f, 1.348399758338928223e+000f, -0.000000000000000000e+000f,
							0.000000000000000000e+000f },
					{ 4.038802087306976318e-001f, 1.347776889801025391e+000f, -1.367439776659011841e-001f,
							4.097724705934524536e-002f },
					{ 3.683817684650421143e-001f, 1.347120404243469238e+000f, -2.147395908832550049e-001f,
							5.872240662574768066e-002f },
					{ 2.726995944976806641e-001f, 1.346765041351318359e+000f, -3.278003931045532227e-001f,
							6.637462973594665527e-002f },
					{ 1.712507456541061401e-001f, 1.347486138343811035e+000f, -3.905014097690582275e-001f,
							4.962845891714096069e-002f },
					{ 2.368136495351791382e-002f, 1.348379015922546387e+000f, -4.257433116436004639e-001f,
							7.477261591702699661e-003f },
					{ 2.368136495351791382e-002f, 1.348379015922546387e+000f, -4.257433116436004639e-001f,
							7.477261591702699661e-003f },
					{ 2.368136495351791382e-002f, 1.348379015922546387e+000f, -4.257433116436004639e-001f,
							7.477261591702699661e-003f } },
			{
					{ 5.230810046195983887e-001f, 1.313920140266418457e+000f, -0.000000000000000000e+000f,
							0.000000000000000000e+000f },
					{ 4.980421066284179688e-001f, 1.312518477439880371e+000f, -1.598993986845016479e-001f,
							6.067467853426933289e-002f },
					{ 4.580144882202148438e-001f, 1.310951709747314453e+000f, -2.526589334011077881e-001f,
							8.827285468578338623e-002f },
					{ 3.463329374790191650e-001f, 1.309825539588928223e+000f, -3.920041322708129883e-001f,
							1.036504060029983521e-001f },
					{ 2.215878367424011230e-001f, 1.311478972434997559e+000f, -4.738276004791259766e-001f,
							8.005803823471069336e-002f },
					{ 3.106109239161014557e-002f, 1.313862204551696777e+000f, -5.221580266952514648e-001f,
							1.234436780214309692e-002f },
					{ 3.106109239161014557e-002f, 1.313862204551696777e+000f, -5.221580266952514648e-001f,
							1.234436780214309692e-002f },
					{ 3.106109239161014557e-002f, 1.313862204551696777e+000f, -5.221580266952514648e-001f,
							1.234436780214309692e-002f } },
			{
					{ 6.336560845375061035e-001f, 1.264310121536254883e+000f, -0.000000000000000000e+000f,
							0.000000000000000000e+000f },
					{ 6.075236797332763672e-001f, 1.261330842971801758e+000f, -1.800969392061233521e-001f,
							8.674421161413192749e-002f },
					{ 5.651465654373168945e-001f, 1.257735133171081543e+000f, -2.865821123123168945e-001f,
							1.287718564271926880e-001f },
					{ 4.418176114559173584e-001f, 1.254143118858337402e+000f, -4.542215466499328613e-001f,
							1.600160896778106689e-001f },
					{ 2.926725447177886963e-001f, 1.257525682449340820e+000f, -5.620167255401611328e-001f,
							1.308019906282424927e-001f },
					{ 4.225754737854003906e-002f, 1.264133453369140625e+000f, -6.322454214096069336e-001f,
							2.113474719226360321e-002f },
					{ 4.225754737854003906e-002f, 1.264133453369140625e+000f, -6.322454214096069336e-001f,
							2.113474719226360321e-002f },
					{ 4.225754737854003906e-002f, 1.264133453369140625e+000f, -6.322454214096069336e-001f,
							2.113474719226360321e-002f } },
			{
					{ 7.546485662460327148e-001f, 1.196037411689758301e+000f, -0.000000000000000000e+000f,
							0.000000000000000000e+000f },
					{ 7.296715378761291504e-001f, 1.190198063850402832e+000f, -1.925457268953323364e-001f,
							1.180435046553611755e-001f },
					{ 6.888567209243774414e-001f, 1.182487130165100098e+000f, -3.081735670566558838e-001f,
							1.795261949300765991e-001f },
					{ 5.658041238784790039e-001f, 1.171467185020446777e+000f, -4.993597567081451416e-001f,
							2.411845624446868896e-001f },
					{ 4.006332457065582275e-001f, 1.176027655601501465e+000f, -6.395213007926940918e-001f,
							2.178635001182556152e-001f },
					{ 6.248449534177780151e-002f, 1.195391178131103516e+000f, -7.520573139190673828e-001f,
							3.931091353297233582e-002f },
					{ 6.248449534177780151e-002f, 1.195391178131103516e+000f, -7.520573139190673828e-001f,
							3.931091353297233582e-002f },
					{ 6.248449534177780151e-002f, 1.195391178131103516e+000f, -7.520573139190673828e-001f,
							3.931091353297233582e-002f } },
			{
					{ 8.796170949935913086e-001f, 1.107372403144836426e+000f, -0.000000000000000000e+000f,
							0.000000000000000000e+000f },
					{ 8.583186864852905273e-001f, 1.097094893455505371e+000f, -1.923940330743789673e-001f,
							1.505206078290939331e-001f },
					{ 8.238825798034667969e-001f, 1.082243204116821289e+000f, -3.081296980381011963e-001f,
							2.345708459615707397e-001f },
					{ 7.213549613952636719e-001f, 1.052233219146728516e+000f, -5.033620595932006836e-001f,
							3.450781702995300293e-001f },
					{ 5.758311152458190918e-001f, 1.044997930526733398e+000f, -6.649397015571594238e-001f,
							3.664054572582244873e-001f },
					{ 1.174122542142868042e-001f, 1.103480935096740723e+000f, -8.717458248138427734e-001f,
							9.275524318218231201e-002f },
					{ 1.174122542142868042e-001f, 1.103480935096740723e+000f, -8.717458248138427734e-001f,
							9.275524318218231201e-002f },
					{ 1.174122542142868042e-001f, 1.103480935096740723e+000f, -8.717458248138427734e-001f,
							9.275524318218231201e-002f } },
			{
					{ 1.000000000000000000e+000f, 1.000000000000000000e+000f, -0.000000000000000000e+000f,
							0.000000000000000000e+000f },
					{ 9.841239452362060547e-001f, 9.841239452362060547e-001f, -1.774824261665344238e-001f,
							1.774824261665344238e-001f },
					{ 9.594738483428955078e-001f, 9.594738483428955078e-001f, -2.817977666854858398e-001f,
							2.817977666854858398e-001f },
					{ 8.946843147277832031e-001f, 8.946843147277832031e-001f, -4.466989934444427490e-001f,
							4.466989934444427490e-001f },
					{ 8.269340991973876953e-001f, 8.269340991973876953e-001f, -5.622988939285278320e-001f,
							5.622988939285278320e-001f },
					{ 7.245688438415527344e-001f, 7.245688438415527344e-001f, -6.892024278640747070e-001f,
							6.892024278640747070e-001f },
					{ 7.245688438415527344e-001f, 7.245688438415527344e-001f, -6.892024278640747070e-001f,
							6.892024278640747070e-001f },
					{ 7.245688438415527344e-001f, 7.245688438415527344e-001f, -6.892024278640747070e-001f,
							6.892024278640747070e-001f } },
			{
					{ 1.107372403144836426e+000f, 8.796170949935913086e-001f, -0.000000000000000000e+000f,
							0.000000000000000000e+000f },
					{ 1.097094893455505371e+000f, 8.583186864852905273e-001f, -1.505206078290939331e-001f,
							1.923940330743789673e-001f },
					{ 1.082243204116821289e+000f, 8.238825798034667969e-001f, -2.345708459615707397e-001f,
							3.081296980381011963e-001f },
					{ 1.052233219146728516e+000f, 7.213549017906188965e-001f, -3.450781404972076416e-001f,
							5.033620595932006836e-001f },
					{ 1.044997930526733398e+000f, 5.758311748504638672e-001f, -3.664054870605468750e-001f,
							6.649397015571594238e-001f },
					{ 1.103480935096740723e+000f, 1.174122393131256104e-001f, -9.275523573160171509e-002f,
							8.717458248138427734e-001f },
					{ 1.103480935096740723e+000f, 1.174122393131256104e-001f, -9.275523573160171509e-002f,
							8.717458248138427734e-001f },
					{ 1.103480935096740723e+000f, 1.174122393131256104e-001f, -9.275523573160171509e-002f,
							8.717458248138427734e-001f } },
			{
					{ 1.196037411689758301e+000f, 7.546485662460327148e-001f, -0.000000000000000000e+000f,
							0.000000000000000000e+000f },
					{ 1.190198063850402832e+000f, 7.296716570854187012e-001f, -1.180435195565223694e-001f,
							1.925457268953323364e-001f },
					{ 1.182487130165100098e+000f, 6.888566017150878906e-001f, -1.795261651277542114e-001f,
							3.081735670566558838e-001f },
					{ 1.171467185020446777e+000f, 5.658041238784790039e-001f, -2.411845624446868896e-001f,
							4.993597567081451416e-001f },
					{ 1.176027655601501465e+000f, 4.006332159042358398e-001f, -2.178634852170944214e-001f,
							6.395213007926940918e-001f },
					{ 1.195391178131103516e+000f, 6.248455122113227844e-002f, -3.931094706058502197e-002f,
							7.520572543144226074e-001f },
					{ 1.195391178131103516e+000f, 6.248455122113227844e-002f, -3.931094706058502197e-002f,
							7.520572543144226074e-001f },
					{ 1.195391178131103516e+000f, 6.248455122113227844e-002f, -3.931094706058502197e-002f,
							7.520572543144226074e-001f } },
			{
					{ 1.264310002326965332e+000f, 6.336560845375061035e-001f, -0.000000000000000000e+000f,
							0.000000000000000000e+000f },
					{ 1.261330723762512207e+000f, 6.075237393379211426e-001f, -8.674423396587371826e-002f,
							1.800969392061233521e-001f },
					{ 1.257735133171081543e+000f, 5.651466846466064453e-001f, -1.287718862295150757e-001f,
							2.865821123123168945e-001f },
					{ 1.254142999649047852e+000f, 4.418176114559173584e-001f, -1.600161194801330566e-001f,
							4.542215764522552490e-001f },
					{ 1.257525682449340820e+000f, 2.926725447177886963e-001f, -1.308019906282424927e-001f,
							5.620167851448059082e-001f },
					{ 1.264133453369140625e+000f, 4.225761815905570984e-002f, -2.113478258252143860e-002f,
							6.322454214096069336e-001f },
					{ 1.264133453369140625e+000f, 4.225761815905570984e-002f, -2.113478258252143860e-002f,
							6.322454214096069336e-001f },
					{ 1.264133453369140625e+000f, 4.225761815905570984e-002f, -2.113478258252143860e-002f,
							6.322454214096069336e-001f } },
			{
					{ 1.313920140266418457e+000f, 5.230810642242431641e-001f, -0.000000000000000000e+000f,
							0.000000000000000000e+000f },
					{ 1.312518477439880371e+000f, 4.980421662330627441e-001f, -6.067468225955963135e-002f,
							1.598993986845016479e-001f },
					{ 1.310951709747314453e+000f, 4.580144882202148438e-001f, -8.827285468578338623e-002f,
							2.526589334011077881e-001f },
					{ 1.309825420379638672e+000f, 3.463329672813415527e-001f, -1.036504283547401428e-001f,
							3.920041620731353760e-001f },
					{ 1.311478972434997559e+000f, 2.215878665447235107e-001f, -8.005806058645248413e-002f,
							4.738276302814483643e-001f },
					{ 1.313862204551696777e+000f, 3.106113709509372711e-002f, -1.234438642859458923e-002f,
							5.221580266952514648e-001f },
					{ 1.313862204551696777e+000f, 3.106113709509372711e-002f, -1.234438642859458923e-002f,
							5.221580266952514648e-001f },
					{ 1.313862204551696777e+000f, 3.106113709509372711e-002f, -1.234438642859458923e-002f,
							5.221580266952514648e-001f } },
			{
					{ 1.348399758338928223e+000f, 4.264014363288879395e-001f, -0.000000000000000000e+000f,
							0.000000000000000000e+000f },
					{ 1.347776889801025391e+000f, 4.038802683353424072e-001f, -4.097725450992584229e-002f,
							1.367439776659011841e-001f },
					{ 1.347120404243469238e+000f, 3.683817386627197266e-001f, -5.872239917516708374e-002f,
							2.147395908832550049e-001f },
					{ 1.346765041351318359e+000f, 2.726996243000030518e-001f, -6.637463718652725220e-002f,
							3.278003931045532227e-001f },
					{ 1.347486138343811035e+000f, 1.712508350610733032e-001f, -4.962848126888275146e-002f,
							3.905014097690582275e-001f },
					{ 1.348379015922546387e+000f, 2.368129603564739227e-002f, -7.477240171283483505e-003f,
							4.257433116436004639e-001f },
					{ 1.348379015922546387e+000f, 2.368129603564739227e-002f, -7.477240171283483505e-003f,
							4.257433116436004639e-001f },
					{ 1.348379015922546387e+000f, 2.368129603564739227e-002f, -7.477240171283483505e-003f,
							4.257433116436004639e-001f } },
			{
					{ 1.380053162574768066e+000f, 3.089554011821746826e-001f, -0.000000000000000000e+000f,
							0.000000000000000000e+000f },
					{ 1.379880905151367188e+000f, 2.911603450775146484e-001f, -2.180509269237518311e-002f,
							1.033397167921066284e-001f },
					{ 1.379709482192993164e+000f, 2.635507583618164062e-001f, -3.079760260879993439e-002f,
							1.612279266119003296e-001f },
					{ 1.379642605781555176e+000f, 1.916256994009017944e-001f, -3.366110846400260925e-002f,
							2.423490136861801147e-001f },
					{ 1.379835009574890137e+000f, 1.186741441488265991e-001f, -2.453357353806495667e-002f,
							2.852540612220764160e-001f },
					{ 1.380048274993896484e+000f, 1.626052893698215485e-002f, -3.635246539488434792e-003f,
							3.085272014141082764e-001f },
					{ 1.380048274993896484e+000f, 1.626052893698215485e-002f, -3.635246539488434792e-003f,
							3.085272014141082764e-001f },
					{ 1.380048274993896484e+000f, 1.626052893698215485e-002f, -3.635246539488434792e-003f,
							3.085272014141082764e-001f } },
			{
					{ 1.396779656410217285e+000f, 2.213746607303619385e-001f, -0.000000000000000000e+000f,
							0.000000000000000000e+000f },
					{ 1.396734118461608887e+000f, 2.080451995134353638e-001f, -1.126914564520120621e-002f,
							7.565663754940032959e-002f },
					{ 1.396690368652343750e+000f, 1.875574588775634766e-001f, -1.579168997704982758e-002f,
							1.175965070724487305e-001f },
					{ 1.396676540374755859e+000f, 1.351680457592010498e-001f, -1.696696691215038300e-002f,
							1.753178089857101440e-001f },
					{ 1.396726131439208984e+000f, 8.318388462066650391e-002f, -1.221807580441236496e-002f,
							2.051515877246856689e-001f },
					{ 1.396778464317321777e+000f, 1.135317143052816391e-002f, -1.796989934518933296e-003f,
							2.210833281278610229e-001f },
					{ 1.396778464317321777e+000f, 1.135317143052816391e-002f, -1.796989934518933296e-003f,
							2.210833281278610229e-001f },
					{ 1.396778464317321777e+000f, 1.135317143052816391e-002f, -1.796989934518933296e-003f,
							2.210833281278610229e-001f } },
			{
					{ 1.405394792556762695e+000f, 1.576879024505615234e-001f, -0.000000000000000000e+000f,
							0.000000000000000000e+000f },
					{ 1.405383110046386719e+000f, 1.479771733283996582e-001f, -5.736523773521184921e-003f,
							5.448146536946296692e-002f },
					{ 1.405372023582458496e+000f, 1.331274956464767456e-001f, -8.005766198039054871e-003f,
							8.451355993747711182e-002f },
					{ 1.405368924140930176e+000f, 9.552086889743804932e-002f, -8.527610450983047485e-003f,
							1.254640966653823853e-001f },
					{ 1.405381560325622559e+000f, 5.860884860157966614e-002f, -6.104988511651754379e-003f,
							1.463915109634399414e-001f },
					{ 1.405394434928894043e+000f, 7.984659634530544281e-003f, -8.947444730438292027e-004f,
							1.574856042861938477e-001f },
					{ 1.405394434928894043e+000f, 7.984659634530544281e-003f, -8.947444730438292027e-004f,
							1.574856042861938477e-001f },
					{ 1.405394434928894043e+000f, 7.984659634530544281e-003f, -8.947444730438292027e-004f,
							1.574856042861938477e-001f } },
			{
					{ 1.409773111343383789e+000f, 1.119822487235069275e-001f, -0.000000000000000000e+000f,
							0.000000000000000000e+000f },
					{ 1.409770131111145020e+000f, 1.050075516104698181e-001f, -2.897708211094141006e-003f,
							3.890293836593627930e-002f },
					{ 1.409767270088195801e+000f, 9.437018632888793945e-002f, -4.035499878227710724e-003f,
							6.028509512543678284e-002f },
					{ 1.409766554832458496e+000f, 6.756380200386047363e-002f, -4.279928747564554214e-003f,
							8.930373191833496094e-002f },
					{ 1.409769654273986816e+000f, 4.139474779367446899e-002f, -3.055210225284099579e-003f,
							1.040504649281501770e-001f },
					{ 1.409772872924804688e+000f, 5.634574219584465027e-003f, -4.470032290555536747e-004f,
							1.118403971195220947e-001f },
					{ 1.409772872924804688e+000f, 5.634574219584465027e-003f, -4.470032290555536747e-004f,
							1.118403971195220947e-001f },
					{ 1.409772872924804688e+000f, 5.634574219584465027e-003f, -4.470032290555536747e-004f,
							1.118403971195220947e-001f } },
			{
					{ 1.411982774734497070e+000f, 7.940161973237991333e-002f, -0.000000000000000000e+000f,
							0.000000000000000000e+000f },
					{ 1.411982059478759766e+000f, 7.442793250083923340e-002f, -1.458030194044113159e-003f,
							2.766048349440097809e-002f },
					{ 1.411981344223022461e+000f, 6.685267388820648193e-002f, -2.028373302891850471e-003f,
							4.284084588289260864e-002f },
					{ 1.411981105804443359e+000f, 4.781045392155647278e-002f, -2.146549988538026810e-003f,
							6.339383125305175781e-002f },
					{ 1.411981940269470215e+000f, 2.927121333777904510e-002f, -1.530110253952443600e-003f,
							7.380931079387664795e-002f },
					{ 1.411982774734497070e+000f, 3.982644062489271164e-003f, -2.236786240246146917e-004f,
							7.930167764425277710e-002f },
					{ 1.411982774734497070e+000f, 3.982644062489271164e-003f, -2.236786240246146917e-004f,
							7.930167764425277710e-002f },
					{ 1.411982774734497070e+000f, 3.982644062489271164e-003f, -2.236786240246146917e-004f,
							7.930167764425277710e-002f } },
			{
					{ 1.413506984710693359e+000f, 4.469902068376541138e-002f, -0.000000000000000000e+000f,
							0.000000000000000000e+000f },
					{ 1.413506865501403809e+000f, 4.188808426260948181e-002f, -4.623219429049640894e-004f,
							1.560098212212324142e-002f },
					{ 1.413506865501403809e+000f, 3.761090710759162903e-002f, -6.426983745768666267e-004f,
							2.415412478148937225e-002f },
					{ 1.413506865501403809e+000f, 2.687769755721092224e-002f, -6.791253690607845783e-004f,
							3.571542352437973022e-002f },
					{ 1.413506865501403809e+000f, 1.644736714661121368e-002f, -4.836216685362160206e-004f,
							4.156303778290748596e-002f },
					{ 1.413506984710693359e+000f, 2.237182576209306717e-003f, -7.065726094879209995e-005f,
							4.464299604296684265e-002f },
					{ 1.413506984710693359e+000f, 2.237182576209306717e-003f, -7.065726094879209995e-005f,
							4.464299604296684265e-002f },
					{ 1.413506984710693359e+000f, 2.237182576209306717e-003f, -7.065726094879209995e-005f,
							4.464299604296684265e-002f } },
			{
					{ 1.413990020751953125e+000f, 2.514469437301158905e-002f, -0.000000000000000000e+000f,
							0.000000000000000000e+000f },
					{ 1.413989901542663574e+000f, 2.356148511171340942e-002f, -1.463245862396433949e-004f,
							8.781343698501586914e-003f },
					{ 1.413990020751953125e+000f, 2.115317061543464661e-002f, -2.033663040492683649e-004f,
							1.359408162534236908e-002f },
					{ 1.413990020751953125e+000f, 1.511300262063741684e-002f, -2.147909399354830384e-004f,
							2.009608969092369080e-002f },
					{ 1.413989901542663574e+000f, 9.246723726391792297e-003f, -1.529105356894433498e-004f,
							2.338276430964469910e-002f },
					{ 1.413990020751953125e+000f, 1.257631462067365646e-003f, -2.233621125924400985e-005f,
							2.511322312057018280e-002f },
					{ 1.413990020751953125e+000f, 1.257631462067365646e-003f, -2.233621125924400985e-005f,
							2.511322312057018280e-002f },
					{ 1.413990020751953125e+000f, 1.257631462067365646e-003f, -2.233621125924400985e-005f,
							2.511322312057018280e-002f } },
			{
					{ 1.414142847061157227e+000f, 1.414142828434705734e-002f, -0.000000000000000000e+000f,
							0.000000000000000000e+000f },
					{ 1.414142966270446777e+000f, 1.325068064033985138e-002f, -4.628446185961365700e-005f,
							4.939583595842123032e-003f },
					{ 1.414142847061157227e+000f, 1.189583446830511093e-002f, -6.432279042201116681e-005f,
							7.646509446203708649e-003f },
					{ 1.414142847061157227e+000f, 8.498409762978553772e-003f, -6.792611384298652411e-005f,
							1.130296476185321808e-002f },
					{ 1.414142966270446777e+000f, 5.199404433369636536e-003f, -4.835214713239111006e-005f,
							1.315090060234069824e-002f },
					{ 1.414142847061157227e+000f, 7.071419968269765377e-004f, -7.062572876748163253e-006f,
							1.412373594939708710e-002f },
					{ 1.414142847061157227e+000f, 7.071419968269765377e-004f, -7.062572876748163253e-006f,
							1.412373594939708710e-002f },
					{ 1.414142847061157227e+000f, 7.071419968269765377e-004f, -7.062572876748163253e-006f,
							1.412373594939708710e-002f } },
			{
					{ 1.414191246032714844e+000f, 7.952581159770488739e-003f, -0.000000000000000000e+000f,
							0.000000000000000000e+000f },
					{ 1.414191246032714844e+000f, 7.451597135514020920e-003f, -1.463768694520695135e-005f,
							2.777993446215987206e-003f },
					{ 1.414191126823425293e+000f, 6.689614150673151016e-003f, -2.034192584687843919e-005f,
							4.300303291529417038e-003f },
					{ 1.414191246032714844e+000f, 4.778962116688489914e-003f, -2.148045132344122976e-005f,
							6.356498226523399353e-003f },
					{ 1.414191246032714844e+000f, 2.923767082393169403e-003f, -1.529005385236814618e-005f,
							7.395616732537746429e-003f },
					{ 1.414191126823425293e+000f, 3.976416192017495632e-004f, -2.233306076959706843e-006f,
							7.942633703351020813e-003f },
					{ 1.414191126823425293e+000f, 3.976416192017495632e-004f, -2.233306076959706843e-006f,
							7.942633703351020813e-003f },
					{ 1.414191126823425293e+000f, 3.976416192017495632e-004f, -2.233306076959706843e-006f,
							7.942633703351020813e-003f } },
			{
					{ 1.414206504821777344e+000f, 4.472113680094480515e-003f, -0.000000000000000000e+000f,
							0.000000000000000000e+000f },
					{ 1.414206504821777344e+000f, 4.190375562757253647e-003f, -4.628969236364355311e-006f,
							1.562227145768702030e-003f },
					{ 1.414206504821777344e+000f, 3.761863801628351212e-003f, -6.432810096157481894e-006f,
							2.418301766738295555e-003f },
					{ 1.414206504821777344e+000f, 2.687399741262197495e-003f, -6.792748536099679768e-006f,
							3.574588801711797714e-003f },
					{ 1.414206504821777344e+000f, 1.644142088480293751e-003f, -4.835115760215558112e-006f,
							4.158918280154466629e-003f },
					{ 1.414206504821777344e+000f, 2.236079162685200572e-004f, -7.062258760015538428e-007f,
							4.466520156711339951e-003f },
					{ 1.414206504821777344e+000f, 2.236079162685200572e-004f, -7.062258760015538428e-007f,
							4.466520156711339951e-003f },
					{ 1.414206504821777344e+000f, 2.236079162685200572e-004f, -7.062258760015538428e-007f,
							4.466520156711339951e-003f } } };
	float[][][][] Q_FRACT_ALLPASS = {
			{
					{ { 8.744080662727355957e-001f, 4.851911962032318115e-001f },
							{ 6.343932747840881348e-001f, 7.730104327201843262e-001f },
							{ 9.175986051559448242e-001f, 3.975082635879516602e-001f } },
					{ { 9.857769012451171875e-001f, 1.680592745542526245e-001f },
							{ 9.569403529167175293e-001f, 2.902846634387969971e-001f },
							{ 9.907300472259521484e-001f, 1.358452588319778442e-001f } },
					{ { 9.857769012451171875e-001f, -1.680592745542526245e-001f },
							{ 9.569403529167175293e-001f, -2.902846634387969971e-001f },
							{ 9.907300472259521484e-001f, -1.358452588319778442e-001f } },
					{ { 8.744080662727355957e-001f, -4.851911962032318115e-001f },
							{ 6.343932747840881348e-001f, -7.730104327201843262e-001f },
							{ 9.175986051559448242e-001f, -3.975082635879516602e-001f } },
					{ { 6.642524003982543945e-001f, -7.475083470344543457e-001f },
							{ 9.801714122295379639e-002f, -9.951847195625305176e-001f },
							{ 7.767338752746582031e-001f, -6.298289299011230469e-001f } },
					{ { 3.790524005889892578e-001f, -9.253752231597900391e-001f },
							{ -4.713967442512512207e-001f, -8.819212913513183594e-001f },
							{ 5.785340070724487305e-001f, -8.156582713127136230e-001f } },
					{ { -1.175374239683151245e-001f, -9.930684566497802734e-001f },
							{ -9.807852506637573242e-001f, -1.950903236865997314e-001f },
							{ 2.066311091184616089e-001f, -9.784189462661743164e-001f } },
					{ { -7.126385569572448730e-001f, -7.015314102172851562e-001f },
							{ -5.555702447891235352e-001f, 8.314695954322814941e-001f },
							{ -3.305967748165130615e-001f, -9.437720775604248047e-001f } },
					{ { -9.947921633720397949e-001f, -1.019244045019149780e-001f },
							{ 5.555702447891235352e-001f, 8.314695954322814941e-001f },
							{ -7.720130085945129395e-001f, -6.356067061424255371e-001f } },
					{ { -8.400934934616088867e-001f, 5.424416065216064453e-001f },
							{ 9.807852506637573242e-001f, -1.950903236865997314e-001f },
							{ -9.896889328956604004e-001f, -1.432335078716278076e-001f } },
					{ { 1.570739597082138062e-002f, 9.998766183853149414e-001f },
							{ -3.826834261417388916e-001f, -9.238795042037963867e-001f },
							{ -7.814115285873413086e-001f, 6.240159869194030762e-001f } },
					{ { 9.792228341102600098e-001f, 2.027871906757354736e-001f },
							{ -3.826834261417388916e-001f, 9.238795042037963867e-001f },
							{ 1.920081824064254761e-001f, 9.813933372497558594e-001f } },
					{ { 4.115142524242401123e-001f, -9.114032983779907227e-001f },
							{ 9.238795042037963867e-001f, -3.826834261417388916e-001f },
							{ 9.589683413505554199e-001f, 2.835132181644439697e-001f } },
					{ { -7.996847629547119141e-001f, -6.004201173782348633e-001f },
							{ -9.238795042037963867e-001f, -3.826834261417388916e-001f },
							{ 6.947838664054870605e-001f, -7.192186117172241211e-001f } },
					{ { -7.604058384895324707e-001f, 6.494481563568115234e-001f },
							{ 3.826834261417388916e-001f, 9.238795042037963867e-001f },
							{ -3.164770305156707764e-001f, -9.486001729965209961e-001f } },
					{ { 4.679299890995025635e-001f, 8.837655186653137207e-001f },
							{ 3.826834261417388916e-001f, -9.238795042037963867e-001f },
							{ -9.874414205551147461e-001f, -1.579856574535369873e-001f } },
					{ { 9.645573496818542480e-001f, -2.638732492923736572e-001f },
							{ -9.238795042037963867e-001f, 3.826834261417388916e-001f },
							{ -5.966450572013854980e-001f, 8.025052547454833984e-001f } },
					{ { -4.710668697953224182e-002f, -9.988898634910583496e-001f },
							{ 9.238795042037963867e-001f, 3.826834261417388916e-001f },
							{ 4.357025325298309326e-001f, 9.000906944274902344e-001f } },
					{ { -9.851093888282775879e-001f, -1.719288527965545654e-001f },
							{ -3.826834261417388916e-001f, -9.238795042037963867e-001f },
							{ 9.995546936988830566e-001f, 2.984059602022171021e-002f } },
					{ { -3.826831877231597900e-001f, 9.238796234130859375e-001f },
							{ -3.826834261417388916e-001f, 9.238795042037963867e-001f },
							{ 4.886211454868316650e-001f, -8.724960684776306152e-001f } },
					{ { 8.181498646736145020e-001f, 5.750049948692321777e-001f },
							{ 9.238795042037963867e-001f, -3.826834261417388916e-001f },
							{ -5.477093458175659180e-001f, -8.366686701774597168e-001f } },
					{ { 7.396308779716491699e-001f, -6.730127334594726562e-001f },
							{ -9.238795042037963867e-001f, -3.826834261417388916e-001f },
							{ -9.951074123382568359e-001f, 9.879885613918304443e-002f } },
					{ { -4.954589605331420898e-001f, -8.686313629150390625e-001f },
							{ 3.826834261417388916e-001f, 9.238795042037963867e-001f },
							{ -3.725017905235290527e-001f, 9.280315041542053223e-001f } },
					{ { -9.557929039001464844e-001f, 2.940406799316406250e-001f },
							{ 3.826834261417388916e-001f, -9.238795042037963867e-001f },
							{ 6.506417989730834961e-001f, 7.593847513198852539e-001f } },
					{ { 7.845948636531829834e-002f, 9.969173073768615723e-001f },
							{ -9.238795042037963867e-001f, 3.826834261417388916e-001f },
							{ 9.741733670234680176e-001f, -2.258014231920242310e-001f } },
					{ { 9.900237321853637695e-001f, 1.409008204936981201e-001f },
							{ 9.238795042037963867e-001f, 3.826834261417388916e-001f },
							{ 2.502108514308929443e-001f, -9.681913852691650391e-001f } },
					{ { 3.534744381904602051e-001f, -9.354441761970520020e-001f },
							{ -3.826834261417388916e-001f, -9.238795042037963867e-001f },
							{ -7.427945137023925781e-001f, -6.695194840431213379e-001f } },
					{ { -8.358076214790344238e-001f, -5.490224361419677734e-001f },
							{ -3.826834261417388916e-001f, 9.238795042037963867e-001f },
							{ -9.370992779731750488e-001f, 3.490629196166992188e-001f } },
					{ { -7.181259393692016602e-001f, 6.959131360054016113e-001f },
							{ 9.238795042037963867e-001f, -3.826834261417388916e-001f },
							{ -1.237744763493537903e-001f, 9.923103451728820801e-001f } },
					{ { 5.224990248680114746e-001f, 8.526399135589599609e-001f },
							{ -9.238795042037963867e-001f, -3.826834261417388916e-001f },
							{ 8.226406574249267578e-001f, 5.685616731643676758e-001f } },
					{ { 0.000000000000000000e+000f, 0.000000000000000000e+000f },
							{ 0.000000000000000000e+000f, 0.000000000000000000e+000f },
							{ 0.000000000000000000e+000f, 0.000000000000000000e+000f } },
					{ { 0.000000000000000000e+000f, 0.000000000000000000e+000f },
							{ 0.000000000000000000e+000f, 0.000000000000000000e+000f },
							{ 0.000000000000000000e+000f, 0.000000000000000000e+000f } },
					{ { 0.000000000000000000e+000f, 0.000000000000000000e+000f },
							{ 0.000000000000000000e+000f, 0.000000000000000000e+000f },
							{ 0.000000000000000000e+000f, 0.000000000000000000e+000f } },
					{ { 0.000000000000000000e+000f, 0.000000000000000000e+000f },
							{ 0.000000000000000000e+000f, 0.000000000000000000e+000f },
							{ 0.000000000000000000e+000f, 0.000000000000000000e+000f } },
					{ { 0.000000000000000000e+000f, 0.000000000000000000e+000f },
							{ 0.000000000000000000e+000f, 0.000000000000000000e+000f },
							{ 0.000000000000000000e+000f, 0.000000000000000000e+000f } },
					{ { 0.000000000000000000e+000f, 0.000000000000000000e+000f },
							{ 0.000000000000000000e+000f, 0.000000000000000000e+000f },
							{ 0.000000000000000000e+000f, 0.000000000000000000e+000f } },
					{ { 0.000000000000000000e+000f, 0.000000000000000000e+000f },
							{ 0.000000000000000000e+000f, 0.000000000000000000e+000f },
							{ 0.000000000000000000e+000f, 0.000000000000000000e+000f } },
					{ { 0.000000000000000000e+000f, 0.000000000000000000e+000f },
							{ 0.000000000000000000e+000f, 0.000000000000000000e+000f },
							{ 0.000000000000000000e+000f, 0.000000000000000000e+000f } },
					{ { 0.000000000000000000e+000f, 0.000000000000000000e+000f },
							{ 0.000000000000000000e+000f, 0.000000000000000000e+000f },
							{ 0.000000000000000000e+000f, 0.000000000000000000e+000f } },
					{ { 0.000000000000000000e+000f, 0.000000000000000000e+000f },
							{ 0.000000000000000000e+000f, 0.000000000000000000e+000f },
							{ 0.000000000000000000e+000f, 0.000000000000000000e+000f } },
					{ { 0.000000000000000000e+000f, 0.000000000000000000e+000f },
							{ 0.000000000000000000e+000f, 0.000000000000000000e+000f },
							{ 0.000000000000000000e+000f, 0.000000000000000000e+000f } },
					{ { 0.000000000000000000e+000f, 0.000000000000000000e+000f },
							{ 0.000000000000000000e+000f, 0.000000000000000000e+000f },
							{ 0.000000000000000000e+000f, 0.000000000000000000e+000f } },
					{ { 0.000000000000000000e+000f, 0.000000000000000000e+000f },
							{ 0.000000000000000000e+000f, 0.000000000000000000e+000f },
							{ 0.000000000000000000e+000f, 0.000000000000000000e+000f } },
					{ { 0.000000000000000000e+000f, 0.000000000000000000e+000f },
							{ 0.000000000000000000e+000f, 0.000000000000000000e+000f },
							{ 0.000000000000000000e+000f, 0.000000000000000000e+000f } },
					{ { 0.000000000000000000e+000f, 0.000000000000000000e+000f },
							{ 0.000000000000000000e+000f, 0.000000000000000000e+000f },
							{ 0.000000000000000000e+000f, 0.000000000000000000e+000f } },
					{ { 0.000000000000000000e+000f, 0.000000000000000000e+000f },
							{ 0.000000000000000000e+000f, 0.000000000000000000e+000f },
							{ 0.000000000000000000e+000f, 0.000000000000000000e+000f } },
					{ { 0.000000000000000000e+000f, 0.000000000000000000e+000f },
							{ 0.000000000000000000e+000f, 0.000000000000000000e+000f },
							{ 0.000000000000000000e+000f, 0.000000000000000000e+000f } },
					{ { 0.000000000000000000e+000f, 0.000000000000000000e+000f },
							{ 0.000000000000000000e+000f, 0.000000000000000000e+000f },
							{ 0.000000000000000000e+000f, 0.000000000000000000e+000f } },
					{ { 0.000000000000000000e+000f, 0.000000000000000000e+000f },
							{ 0.000000000000000000e+000f, 0.000000000000000000e+000f },
							{ 0.000000000000000000e+000f, 0.000000000000000000e+000f } },
					{ { 0.000000000000000000e+000f, 0.000000000000000000e+000f },
							{ 0.000000000000000000e+000f, 0.000000000000000000e+000f },
							{ 0.000000000000000000e+000f, 0.000000000000000000e+000f } }, },
			{
					{ { 9.936702847480773926e-001f, -1.123361140489578247e-001f },
							{ 9.807852506637573242e-001f, -1.950903236865997314e-001f },
							{ 9.958764910697937012e-001f, -9.071949124336242676e-002f } },
					{ { 9.435121417045593262e-001f, -3.313378989696502686e-001f },
							{ 8.314695954322814941e-001f, -5.555702447891235352e-001f },
							{ 9.630921483039855957e-001f, -2.691719830036163330e-001f } },
					{ { 8.457278013229370117e-001f, -5.336145162582397461e-001f },
							{ 5.555702447891235352e-001f, -8.314695954322814941e-001f },
							{ 8.986026644706726074e-001f, -4.387632906436920166e-001f } },
					{ { 7.052531242370605469e-001f, -7.089555859565734863e-001f },
							{ 1.950903236865997314e-001f, -9.807852506637573242e-001f },
							{ 8.045311570167541504e-001f, -5.939104557037353516e-001f } },
					{ { 5.291789770126342773e-001f, -8.485102057456970215e-001f },
							{ -1.950903236865997314e-001f, -9.807852506637573242e-001f },
							{ 6.839743852615356445e-001f, -7.295060753822326660e-001f } },
					{ { 3.263931274414062500e-001f, -9.452341198921203613e-001f },
							{ -5.555702447891235352e-001f, -8.314695954322814941e-001f },
							{ 5.409010648727416992e-001f, -8.410862088203430176e-001f } },
					{ { 1.071317270398139954e-001f, -9.942448139190673828e-001f },
							{ -8.314695954322814941e-001f, -5.555702447891235352e-001f },
							{ 3.800212442874908447e-001f, -9.249777793884277344e-001f } },
					{ { -1.175374239683151245e-001f, -9.930684566497802734e-001f },
							{ -9.807852506637573242e-001f, -1.950903236865997314e-001f },
							{ 2.066311091184616089e-001f, -9.784189462661743164e-001f } },
					{ { -3.362735807895660400e-001f, -9.417643547058105469e-001f },
							{ -9.807852506637573242e-001f, 1.950903236865997314e-001f },
							{ 2.643864415585994720e-002f, -9.996504187583923340e-001f } },
					{ { 8.457278013229370117e-001f, 5.336145162582397461e-001f },
							{ 5.555702447891235352e-001f, 8.314695954322814941e-001f },
							{ 8.986026644706726074e-001f, 4.387632906436920166e-001f } },
					{ { 9.435121417045593262e-001f, 3.313378989696502686e-001f },
							{ 8.314695954322814941e-001f, 5.555702447891235352e-001f },
							{ 9.630921483039855957e-001f, 2.691719830036163330e-001f } },
					{ { 9.936702847480773926e-001f, 1.123361140489578247e-001f },
							{ 9.807852506637573242e-001f, 1.950903236865997314e-001f },
							{ 9.958764910697937012e-001f, 9.071949124336242676e-002f } },
					{ { -9.635137915611267090e-001f, -2.676587700843811035e-001f },
							{ 2.902846634387969971e-001f, 9.569403529167175293e-001f },
							{ -6.785123348236083984e-001f, -7.345889806747436523e-001f } },
					{ { -9.977724552154541016e-001f, 6.670931726694107056e-002f },
							{ 7.730104327201843262e-001f, 6.343932747840881348e-001f },
							{ -8.512006402015686035e-001f, -5.248404145240783691e-001f } },
					{ { 6.642524003982543945e-001f, -7.475083470344543457e-001f },
							{ 9.801714122295379639e-002f, -9.951847195625305176e-001f },
							{ 7.767338752746582031e-001f, -6.298289299011230469e-001f } },
					{ { 3.790524005889892578e-001f, -9.253752231597900391e-001f },
							{ -4.713967442512512207e-001f, -8.819212913513183594e-001f },
							{ 5.785340070724487305e-001f, -8.156582713127136230e-001f } },
					{ { 5.102868378162384033e-002f, -9.986971616744995117e-001f },
							{ -8.819212913513183594e-001f, -4.713967442512512207e-001f },
							{ 3.376292288303375244e-001f, -9.412791728973388672e-001f } },
					{ { -2.827600538730621338e-001f, -9.591906666755676270e-001f },
							{ -9.951847195625305176e-001f, 9.801714122295379639e-002f },
							{ 7.180207967758178711e-002f, -9.974188804626464844e-001f } },
					{ { -5.846037268638610840e-001f, -8.113189339637756348e-001f },
							{ -7.730104327201843262e-001f, 6.343932747840881348e-001f },
							{ -1.993251889944076538e-001f, -9.799333810806274414e-001f } },
					{ { -8.204014897346496582e-001f, -5.717879533767700195e-001f },
							{ -2.902846634387969971e-001f, 9.569403529167175293e-001f },
							{ -4.557391405105590820e-001f, -8.901134133338928223e-001f } },
					{ { -9.947921633720397949e-001f, -1.019244045019149780e-001f },
							{ 5.555702447891235352e-001f, 8.314695954322814941e-001f },
							{ -7.720130085945129395e-001f, -6.356067061424255371e-001f } },
					{ { -8.400934934616088867e-001f, 5.424416065216064453e-001f },
							{ 9.807852506637573242e-001f, -1.950903236865997314e-001f },
							{ -9.896889328956604004e-001f, -1.432335078716278076e-001f } },
					{ { -3.164769113063812256e-001f, 9.486002326011657715e-001f },
							{ 1.950903236865997314e-001f, -9.807852506637573242e-001f },
							{ -9.205389618873596191e-001f, 3.906508386135101318e-001f } },
					{ { -7.126385569572448730e-001f, -7.015314102172851562e-001f },
							{ -5.555702447891235352e-001f, 8.314695954322814941e-001f },
							{ -3.305967748165130615e-001f, -9.437720775604248047e-001f } },
					{ { 8.567175865173339844e-001f, 5.157858133316040039e-001f },
							{ -8.314695954322814941e-001f, 5.555702447891235352e-001f },
							{ -7.924201339483261108e-002f, 9.968553781509399414e-001f } },
					{ { -8.400934934616088867e-001f, 5.424416065216064453e-001f },
							{ 9.807852506637573242e-001f, -1.950903236865997314e-001f },
							{ -9.896889328956604004e-001f, -1.432335078716278076e-001f } },
					{ { -3.164769113063812256e-001f, 9.486002326011657715e-001f },
							{ 1.950903236865997314e-001f, -9.807852506637573242e-001f },
							{ -9.205389618873596191e-001f, 3.906508386135101318e-001f } },
					{ { 3.461171388626098633e-001f, 9.381912946701049805e-001f },
							{ -8.314695954322814941e-001f, -5.555702447891235352e-001f },
							{ -5.846037268638610840e-001f, 8.113189935684204102e-001f } },
					{ { 8.567175865173339844e-001f, 5.157858133316040039e-001f },
							{ -8.314695954322814941e-001f, 5.555702447891235352e-001f },
							{ -7.924201339483261108e-002f, 9.968553781509399414e-001f } },
					{ { 9.910997152328491211e-001f, -1.331214457750320435e-001f },
							{ 1.950903236865997314e-001f, 9.807852506637573242e-001f },
							{ 4.490851461887359619e-001f, 8.934889435768127441e-001f } },
					{ { 6.902511715888977051e-001f, -7.235698699951171875e-001f },
							{ 9.807852506637573242e-001f, 1.950903236865997314e-001f },
							{ 8.472610116004943848e-001f, 5.311767458915710449e-001f } },
					{ { 3.461171388626098633e-001f, 9.381912946701049805e-001f },
							{ -8.314695954322814941e-001f, -5.555702447891235352e-001f },
							{ -5.846037268638610840e-001f, 8.113189935684204102e-001f } },
					{ { 4.115142524242401123e-001f, -9.114032983779907227e-001f },
							{ 9.238795042037963867e-001f, -3.826834261417388916e-001f },
							{ 9.589683413505554199e-001f, 2.835132181644439697e-001f } },
					{ { -7.996847629547119141e-001f, -6.004201173782348633e-001f },
							{ -9.238795042037963867e-001f, -3.826834261417388916e-001f },
							{ 6.947838664054870605e-001f, -7.192186117172241211e-001f } },
					{ { -7.604058384895324707e-001f, 6.494481563568115234e-001f },
							{ 3.826834261417388916e-001f, 9.238795042037963867e-001f },
							{ -3.164770305156707764e-001f, -9.486001729965209961e-001f } },
					{ { 4.679299890995025635e-001f, 8.837655186653137207e-001f },
							{ 3.826834261417388916e-001f, -9.238795042037963867e-001f },
							{ -9.874414205551147461e-001f, -1.579856574535369873e-001f } },
					{ { 9.645573496818542480e-001f, -2.638732492923736572e-001f },
							{ -9.238795042037963867e-001f, 3.826834261417388916e-001f },
							{ -5.966450572013854980e-001f, 8.025052547454833984e-001f } },
					{ { -4.710668697953224182e-002f, -9.988898634910583496e-001f },
							{ 9.238795042037963867e-001f, 3.826834261417388916e-001f },
							{ 4.357025325298309326e-001f, 9.000906944274902344e-001f } },
					{ { -9.851093888282775879e-001f, -1.719288527965545654e-001f },
							{ -3.826834261417388916e-001f, -9.238795042037963867e-001f },
							{ 9.995546936988830566e-001f, 2.984059602022171021e-002f } },
					{ { -3.826831877231597900e-001f, 9.238796234130859375e-001f },
							{ -3.826834261417388916e-001f, 9.238795042037963867e-001f },
							{ 4.886211454868316650e-001f, -8.724960684776306152e-001f } },
					{ { 8.181498646736145020e-001f, 5.750049948692321777e-001f },
							{ 9.238795042037963867e-001f, -3.826834261417388916e-001f },
							{ -5.477093458175659180e-001f, -8.366686701774597168e-001f } },
					{ { 7.396308779716491699e-001f, -6.730127334594726562e-001f },
							{ -9.238795042037963867e-001f, -3.826834261417388916e-001f },
							{ -9.951074123382568359e-001f, 9.879885613918304443e-002f } },
					{ { -4.954589605331420898e-001f, -8.686313629150390625e-001f },
							{ 3.826834261417388916e-001f, 9.238795042037963867e-001f },
							{ -3.725017905235290527e-001f, 9.280315041542053223e-001f } },
					{ { -9.557929039001464844e-001f, 2.940406799316406250e-001f },
							{ 3.826834261417388916e-001f, -9.238795042037963867e-001f },
							{ 6.506417989730834961e-001f, 7.593847513198852539e-001f } },
					{ { 7.845948636531829834e-002f, 9.969173073768615723e-001f },
							{ -9.238795042037963867e-001f, 3.826834261417388916e-001f },
							{ 9.741733670234680176e-001f, -2.258014231920242310e-001f } },
					{ { 9.900237321853637695e-001f, 1.409008204936981201e-001f },
							{ 9.238795042037963867e-001f, 3.826834261417388916e-001f },
							{ 2.502108514308929443e-001f, -9.681913852691650391e-001f } },
					{ { 3.534744381904602051e-001f, -9.354441761970520020e-001f },
							{ -3.826834261417388916e-001f, -9.238795042037963867e-001f },
							{ -7.427945137023925781e-001f, -6.695194840431213379e-001f } },
					{ { -8.358076214790344238e-001f, -5.490224361419677734e-001f },
							{ -3.826834261417388916e-001f, 9.238795042037963867e-001f },
							{ -9.370992779731750488e-001f, 3.490629196166992188e-001f } },
					{ { -7.181259393692016602e-001f, 6.959131360054016113e-001f },
							{ 9.238795042037963867e-001f, -3.826834261417388916e-001f },
							{ -1.237744763493537903e-001f, 9.923103451728820801e-001f } },
					{ { 5.224990248680114746e-001f, 8.526399135589599609e-001f },
							{ -9.238795042037963867e-001f, -3.826834261417388916e-001f },
							{ 8.226406574249267578e-001f, 5.685616731643676758e-001f } } } };
	float[][][] PHI_FRACT = {
			{ { 8.962930440902709961e-001f, 4.434623122215270996e-001f },
					{ 9.882950186729431152e-001f, 1.525546163320541382e-001f },
					{ 9.882950186729431152e-001f, -1.525546163320541382e-001f },
					{ 8.962930440902709961e-001f, -4.434623122215270996e-001f },
					{ 7.208536267280578613e-001f, -6.930873394012451172e-001f },
					{ 4.783087670803070068e-001f, -8.781917691230773926e-001f },
					{ 3.925987333059310913e-002f, -9.992290139198303223e-001f },
					{ -5.424414873123168945e-001f, -8.400936126708984375e-001f },
					{ -9.268565773963928223e-001f, -3.754156529903411865e-001f },
					{ -9.741734266281127930e-001f, 2.258011400699615479e-001f },
					{ -4.115144908428192139e-001f, 9.114032387733459473e-001f },
					{ 7.181261777877807617e-001f, 6.959129571914672852e-001f },
					{ 8.980276584625244141e-001f, -4.399389624595642090e-001f },
					{ -1.097340211272239685e-001f, -9.939609766006469727e-001f },
					{ -9.723698496818542480e-001f, -2.334456890821456909e-001f },
					{ -5.490231513977050781e-001f, 8.358071446418762207e-001f },
					{ 6.004198789596557617e-001f, 7.996849417686462402e-001f },
					{ 9.557931423187255859e-001f, -2.940398752689361572e-001f },
					{ 4.710696637630462646e-002f, -9.988898634910583496e-001f },
					{ -9.238793253898620605e-001f, -3.826839625835418701e-001f },
					{ -6.730129718780517578e-001f, 7.396306991577148438e-001f },
					{ 4.679292440414428711e-001f, 8.837659358978271484e-001f },
					{ 9.900237321853637695e-001f, -1.409005373716354370e-001f },
					{ 2.027880251407623291e-001f, -9.792226552963256836e-001f },
					{ -8.526397347450256348e-001f, -5.224992632865905762e-001f },
					{ -7.804309129714965820e-001f, 6.252419948577880859e-001f },
					{ 3.239165842533111572e-001f, 9.460856318473815918e-001f },
					{ 9.998766183853149414e-001f, 1.570823788642883301e-002f },
					{ 3.534757494926452637e-001f, -9.354436993598937988e-001f },
					{ -7.604053020477294922e-001f, -6.494488120079040527e-001f },
					{ 0.000000000000000000e+000f, 0.000000000000000000e+000f },
					{ 0.000000000000000000e+000f, 0.000000000000000000e+000f },
					{ 0.000000000000000000e+000f, 0.000000000000000000e+000f },
					{ 0.000000000000000000e+000f, 0.000000000000000000e+000f },
					{ 0.000000000000000000e+000f, 0.000000000000000000e+000f },
					{ 0.000000000000000000e+000f, 0.000000000000000000e+000f },
					{ 0.000000000000000000e+000f, 0.000000000000000000e+000f },
					{ 0.000000000000000000e+000f, 0.000000000000000000e+000f },
					{ 0.000000000000000000e+000f, 0.000000000000000000e+000f },
					{ 0.000000000000000000e+000f, 0.000000000000000000e+000f },
					{ 0.000000000000000000e+000f, 0.000000000000000000e+000f },
					{ 0.000000000000000000e+000f, 0.000000000000000000e+000f },
					{ 0.000000000000000000e+000f, 0.000000000000000000e+000f },
					{ 0.000000000000000000e+000f, 0.000000000000000000e+000f },
					{ 0.000000000000000000e+000f, 0.000000000000000000e+000f },
					{ 0.000000000000000000e+000f, 0.000000000000000000e+000f },
					{ 0.000000000000000000e+000f, 0.000000000000000000e+000f },
					{ 0.000000000000000000e+000f, 0.000000000000000000e+000f },
					{ 0.000000000000000000e+000f, 0.000000000000000000e+000f },
					{ 0.000000000000000000e+000f, 0.000000000000000000e+000f } },
			{ { 9.947921633720397949e-001f, -1.019244492053985596e-001f },
					{ 9.534541964530944824e-001f, -3.015379607677459717e-001f },
					{ 8.724960088729858398e-001f, -4.886212348937988281e-001f },
					{ 7.552818059921264648e-001f, -6.554001569747924805e-001f },
					{ 6.066823601722717285e-001f, -7.949443459510803223e-001f },
					{ 4.328726232051849365e-001f, -9.014551043510437012e-001f },
					{ 2.410751134157180786e-001f, -9.705064892768859863e-001f },
					{ 3.925987333059310913e-002f, -9.992290139198303223e-001f },
					{ -1.641867905855178833e-001f, -9.864292740821838379e-001f },
					{ 8.724960088729858398e-001f, 4.886212348937988281e-001f },
					{ 9.534541964530944824e-001f, 3.015379607677459717e-001f },
					{ 9.947921633720397949e-001f, 1.019244492053985596e-001f },
					{ -8.587363362312316895e-001f, -5.124176740646362305e-001f },
					{ -9.732791185379028320e-001f, -2.296251952648162842e-001f },
					{ 7.208536267280578613e-001f, -6.930873394012451172e-001f },
					{ 4.783087670803070068e-001f, -8.781917691230773926e-001f },
					{ 1.912373453378677368e-001f, -9.815438389778137207e-001f },
					{ -1.136366724967956543e-001f, -9.935223460197448730e-001f },
					{ -4.079320430755615234e-001f, -9.130122661590576172e-001f },
					{ -6.642524003982543945e-001f, -7.475084066390991211e-001f },
					{ -9.268565773963928223e-001f, -3.754156529903411865e-001f },
					{ -9.741734266281127930e-001f, 2.258011400699615479e-001f },
					{ -6.671828627586364746e-001f, 7.448939681053161621e-001f },
					{ -5.424414873123168945e-001f, -8.400936126708984375e-001f },
					{ 4.748562276363372803e-001f, 8.800634145736694336e-001f },
					{ -9.741734266281127930e-001f, 2.258011400699615479e-001f },
					{ -6.671828627586364746e-001f, 7.448939681053161621e-001f },
					{ -1.175375655293464661e-001f, 9.930684566497802734e-001f },
					{ 4.748562276363372803e-001f, 8.800634145736694336e-001f },
					{ 8.945445418357849121e-001f, 4.469788074493408203e-001f },
					{ 9.888865351676940918e-001f, -1.486721932888031006e-001f },
					{ -1.175375655293464661e-001f, 9.930684566497802734e-001f },
					{ 8.980276584625244141e-001f, -4.399389624595642090e-001f },
					{ -1.097340211272239685e-001f, -9.939609766006469727e-001f },
					{ -9.723698496818542480e-001f, -2.334456890821456909e-001f },
					{ -5.490231513977050781e-001f, 8.358071446418762207e-001f },
					{ 6.004198789596557617e-001f, 7.996849417686462402e-001f },
					{ 9.557931423187255859e-001f, -2.940398752689361572e-001f },
					{ 4.710696637630462646e-002f, -9.988898634910583496e-001f },
					{ -9.238793253898620605e-001f, -3.826839625835418701e-001f },
					{ -6.730129718780517578e-001f, 7.396306991577148438e-001f },
					{ 4.679292440414428711e-001f, 8.837659358978271484e-001f },
					{ 9.900237321853637695e-001f, -1.409005373716354370e-001f },
					{ 2.027880251407623291e-001f, -9.792226552963256836e-001f },
					{ -8.526397347450256348e-001f, -5.224992632865905762e-001f },
					{ -7.804309129714965820e-001f, 6.252419948577880859e-001f },
					{ 3.239165842533111572e-001f, 9.460856318473815918e-001f },
					{ 9.998766183853149414e-001f, 1.570823788642883301e-002f },
					{ 3.534757494926452637e-001f, -9.354436993598937988e-001f },
					{ -7.604053020477294922e-001f, -6.494488120079040527e-001f } } };
}
