package ac.mdiq.podcini.config

import ac.mdiq.podcini.PodciniApp.Companion.getAppContext
import ac.mdiq.podcini.gears.gearbox
import ac.mdiq.podcini.net.download.service.DownloadServiceInterface
import ac.mdiq.podcini.net.download.service.DownloadServiceInterfaceImpl
import ac.mdiq.podcini.net.download.service.PodciniHttpClient.setCacheDirectory
import ac.mdiq.podcini.net.download.service.PodciniHttpClient.setProxyConfig
import ac.mdiq.podcini.net.ssl.SslProviderInstaller
import ac.mdiq.podcini.net.sync.SyncService
import ac.mdiq.podcini.net.sync.queue.SynchronizationQueueSink
import ac.mdiq.podcini.preferences.AppPreferences
import ac.mdiq.podcini.preferences.AppPreferences.proxyConfig
import ac.mdiq.podcini.storage.database.cancelQueuesJob
import ac.mdiq.podcini.storage.database.getRealmInstance
import ac.mdiq.podcini.storage.database.initQueues
import ac.mdiq.podcini.utils.Logd
import ac.mdiq.podcini.utils.timeIt
import java.io.File


object ClientConfigurator {
    private var initialized = false

    @Synchronized
    fun initialize() {
        if (initialized) return
        Logd("ClientConfigurator", "initialize")
        timeIt("ClientConfigurator Init started ")

        AppPreferences.init()
        getRealmInstance()

        initQueues()
        SslProviderInstaller.install()
        DownloadServiceInterface.impl = DownloadServiceInterfaceImpl()
        SynchronizationQueueSink.setServiceStarterImpl { SyncService.sync() }
        setCacheDirectory(File(getAppContext().cacheDir, "okhttp"))
        setProxyConfig(proxyConfig)
        createChannels()
        gearbox.init()

        timeIt("ClientConfigurator Init ends ")
        initialized = true
    }

    fun destroy() {
        cancelQueuesJob()
    }
}
