/*
 * c_openssl.c - Static OpenSSL class
 *
 * Copyright (C) 2019 Tobias Boege <tobias@gambas-buch.de>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301, USA.
 *
 * In addition, as a special exception, the copyright holders give
 * permission to link the code of portions of this program with the
 * OpenSSL library under certain conditions as described in each
 * individual source file, and distribute linked combinations
 * including the two.
 * You must obey the GNU General Public License in all respects
 * for all of the code used other than OpenSSL. If you modify
 * file(s) with this exception, you may extend this exception to
 * your version of the file(s), but you are not obligated to do so.
 * If you do not wish to do so, delete this exception statement
 * from your version. If you delete this exception statement from
 * all source files in the program, then also delete it here.
 */

#define __C_OPENSSL_C

#include <openssl/crypto.h>
#include <openssl/rand.h>
#include <openssl/err.h>

#include "main.h"
#include "c_openssl.h"

/*
 * OpenSSL
 */

/**G
 * Return a cryptographically strongly pseudo-random string of the
 * given *Length*.
 **/
BEGIN_METHOD(OpenSSL_RandomBytes, GB_INTEGER length)

	char *ret = GB.TempString(NULL, VARG(length));
	int res;

	#if OPENSSL_VERSION_NUMBER < 0x10100000L
	res = RAND_pseudo_bytes((unsigned char *) ret, VARG(length));
	#else
	res = RAND_bytes((unsigned char *) ret, VARG(length));
	#endif
	if (res == -1) {
		GB.Error("Random number generator not supported");
		return;
	} else if (res == 0) {
		GB.Error(ERR_error_string(ERR_get_error(), NULL));
		return;
	}

	GB.ReturnString(ret);

END_METHOD

GB_DESC COpenSSL[] = {
	GB_DECLARE_STATIC("OpenSSL"),

	GB_STATIC_METHOD("RandomBytes", "s", OpenSSL_RandomBytes, "(Length)i"),

	GB_END_DECLARE
};
