; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --version 5
; RUN: opt -S -passes=instcombine %s | FileCheck %s
; RUN: opt -S -passes=instcombine -use-constant-fp-for-fixed-length-splat %s | FileCheck %s

define float @fabs_fneg_basic(float %x) {
; CHECK-LABEL: define float @fabs_fneg_basic(
; CHECK-SAME: float [[X:%.*]]) {
; CHECK-NEXT:    [[FABS:%.*]] = call float @llvm.fabs.f32(float [[X]])
; CHECK-NEXT:    ret float [[FABS]]
;
  %neg = fneg float %x
  %fabs = call float @llvm.fabs.f32(float %neg)
  ret float %fabs
}

define <2 x float> @fabs_fneg_v2f32(<2 x float> %x) {
; CHECK-LABEL: define <2 x float> @fabs_fneg_v2f32(
; CHECK-SAME: <2 x float> [[X:%.*]]) {
; CHECK-NEXT:    [[FABS:%.*]] = call <2 x float> @llvm.fabs.v2f32(<2 x float> [[X]])
; CHECK-NEXT:    ret <2 x float> [[FABS]]
;
  %neg = fneg <2 x float> %x
  %fabs = call <2 x float> @llvm.fabs.v2f32(<2 x float> %neg)
  ret <2 x float> %fabs
}

define double @fabs_fneg_f64(double %x) {
; CHECK-LABEL: define double @fabs_fneg_f64(
; CHECK-SAME: double [[X:%.*]]) {
; CHECK-NEXT:    [[FABS:%.*]] = call double @llvm.fabs.f64(double [[X]])
; CHECK-NEXT:    ret double [[FABS]]
;
  %neg = fneg double %x
  %fabs = call double @llvm.fabs.f64(double %neg)
  ret double %fabs
}

define <4 x double> @fabs_fneg_v4f64(<4 x double> %x) {
; CHECK-LABEL: define <4 x double> @fabs_fneg_v4f64(
; CHECK-SAME: <4 x double> [[X:%.*]]) {
; CHECK-NEXT:    [[FABS:%.*]] = call <4 x double> @llvm.fabs.v4f64(<4 x double> [[X]])
; CHECK-NEXT:    ret <4 x double> [[FABS]]
;
  %neg = fneg <4 x double> %x
  %fabs = call <4 x double> @llvm.fabs.v4f64(<4 x double> %neg)
  ret <4 x double> %fabs
}

define half @fabs_fneg_f16(half %x) {
; CHECK-LABEL: define half @fabs_fneg_f16(
; CHECK-SAME: half [[X:%.*]]) {
; CHECK-NEXT:    [[FABS:%.*]] = call half @llvm.fabs.f16(half [[X]])
; CHECK-NEXT:    ret half [[FABS]]
;
  %neg = fneg half %x
  %fabs = call half @llvm.fabs.f16(half %neg)
  ret half %fabs
}

define float @fabs_copysign_nnan(float %x, float %y) {
; CHECK-LABEL: define float @fabs_copysign_nnan(
; CHECK-SAME: float [[X:%.*]], float [[Y:%.*]]) {
; CHECK-NEXT:    [[FABS:%.*]] = call nnan float @llvm.fabs.f32(float [[X]])
; CHECK-NEXT:    ret float [[FABS]]
;
  %copysign = call float @llvm.copysign.f32(float %x, float %y)
  %fabs = call nnan float @llvm.fabs.f32(float %copysign)
  ret float %fabs
}


define float @fabs_copysign_ninf(float %x, float %y) {
; CHECK-LABEL: define float @fabs_copysign_ninf(
; CHECK-SAME: float [[X:%.*]], float [[Y:%.*]]) {
; CHECK-NEXT:    [[FABS:%.*]] = call ninf float @llvm.fabs.f32(float [[X]])
; CHECK-NEXT:    ret float [[FABS]]
;
  %copysign = call float @llvm.copysign.f32(float %x, float %y)
  %fabs = call ninf float @llvm.fabs.f32(float %copysign)
  ret float %fabs
}

define float @fabs_copysign_nsz(float %x, float %y) {
; CHECK-LABEL: define float @fabs_copysign_nsz(
; CHECK-SAME: float [[X:%.*]], float [[Y:%.*]]) {
; CHECK-NEXT:    [[FABS:%.*]] = call nsz float @llvm.fabs.f32(float [[X]])
; CHECK-NEXT:    ret float [[FABS]]
;
  %copysign = call float @llvm.copysign.f32(float %x, float %y)
  %fabs = call nsz float @llvm.fabs.f32(float %copysign)
  ret float %fabs
}

define float @fabs_copysign_nnan_negative(float %x, float %y) {
; CHECK-LABEL: define float @fabs_copysign_nnan_negative(
; CHECK-SAME: float [[X:%.*]], float [[Y:%.*]]) {
; CHECK-NEXT:    [[FABS:%.*]] = call nnan float @llvm.fabs.f32(float [[X]])
; CHECK-NEXT:    ret float [[FABS]]
;
  %copysign = call float @llvm.copysign.f32(float %x, float %y)
  %fabs = call nnan float @llvm.fabs.f32(float %copysign)
  ret float %fabs
}


define float @fabs_copysign_ninf_negative(float %x, float %y) {
; CHECK-LABEL: define float @fabs_copysign_ninf_negative(
; CHECK-SAME: float [[X:%.*]], float [[Y:%.*]]) {
; CHECK-NEXT:    [[FABS:%.*]] = call ninf float @llvm.fabs.f32(float [[X]])
; CHECK-NEXT:    ret float [[FABS]]
;
  %copysign = call float @llvm.copysign.f32(float %x, float %y)
  %fabs = call ninf float @llvm.fabs.f32(float %copysign)
  ret float %fabs
}

define float @fabs_copysign_nsz_negative(float %x, float %y) {
; CHECK-LABEL: define float @fabs_copysign_nsz_negative(
; CHECK-SAME: float [[X:%.*]], float [[Y:%.*]]) {
; CHECK-NEXT:    [[FABS:%.*]] = call nsz float @llvm.fabs.f32(float [[X]])
; CHECK-NEXT:    ret float [[FABS]]
;
  %copysign = call float @llvm.copysign.f32(float %x, float %y)
  %fabs = call nsz float @llvm.fabs.f32(float %copysign)
  ret float %fabs
}

define float @fabs_fneg_no_fabs(float %x) {
; CHECK-LABEL: define float @fabs_fneg_no_fabs(
; CHECK-SAME: float [[X:%.*]]) {
; CHECK-NEXT:    [[NEG:%.*]] = fneg float [[X]]
; CHECK-NEXT:    ret float [[NEG]]
;
  %neg = fneg float %x
  ret float %neg
}

define <2 x float> @fabs_fneg_splat_v2f32(<2 x float> %x) {
; CHECK-LABEL: define <2 x float> @fabs_fneg_splat_v2f32(
; CHECK-SAME: <2 x float> [[X:%.*]]) {
; CHECK-NEXT:    ret <2 x float> splat (float 2.000000e+00)
;
  %neg = fneg <2 x float> <float -2.0, float -2.0>
  %fabs = call <2 x float> @llvm.fabs.v2f32(<2 x float> %neg)
  ret <2 x float> %fabs
}


define <2 x float> @fabs_fneg_splat_poison_v2f32(<2 x float> %x) {
; CHECK-LABEL: define <2 x float> @fabs_fneg_splat_poison_v2f32(
; CHECK-SAME: <2 x float> [[X:%.*]]) {
; CHECK-NEXT:    [[FABS:%.*]] = call <2 x float> @llvm.fabs.v2f32(<2 x float> <float -2.000000e+00, float poison>)
; CHECK-NEXT:    ret <2 x float> [[FABS]]
;
  %neg = fneg <2 x float> <float 2.0, float poison>
  %fabs = call <2 x float> @llvm.fabs.v2f32(<2 x float> %neg)
  ret <2 x float> %fabs
}

define <2 x float> @fabs_fneg_non_splat_v2f32(<2 x float> %x) {
; CHECK-LABEL: define <2 x float> @fabs_fneg_non_splat_v2f32(
; CHECK-SAME: <2 x float> [[X:%.*]]) {
; CHECK-NEXT:    ret <2 x float> <float 2.000000e+00, float 3.000000e+00>
;
  %neg = fneg <2 x float> <float 2.0, float 3.0>
  %fabs = call <2 x float> @llvm.fabs.v2f32(<2 x float> %neg)
  ret <2 x float> %fabs
}

declare void @use(float)

define float @fabs_fneg_multi_use(float %x) {
; CHECK-LABEL: define float @fabs_fneg_multi_use(
; CHECK-SAME: float [[X:%.*]]) {
; CHECK-NEXT:    [[NEG:%.*]] = fneg float [[X]]
; CHECK-NEXT:    call void @use(float [[NEG]])
; CHECK-NEXT:    [[FABS:%.*]] = call float @llvm.fabs.f32(float [[X]])
; CHECK-NEXT:    ret float [[FABS]]
;
  %neg = fneg float %x
  call void @use(float %neg)
  %fabs = call float @llvm.fabs.f32(float %neg)
  ret float %fabs
}



