; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=x86_64-apple-darwin -mattr=+shstk --show-mc-encoding | FileCheck %s
; RUN: llc < %s -mtriple=x86_64-apple-darwin -mattr=+shstk,+egpr --show-mc-encoding | FileCheck %s -check-prefix=EGPR

define void @test_incsspd(i32 %a) local_unnamed_addr {
; CHECK-LABEL: test_incsspd:
; CHECK:       ## %bb.0: ## %entry
; CHECK-NEXT:    incsspd %edi ## encoding: [0xf3,0x0f,0xae,0xef]
; CHECK-NEXT:    retq ## encoding: [0xc3]
;
; EGPR-LABEL: test_incsspd:
; EGPR:       ## %bb.0: ## %entry
; EGPR-NEXT:    incsspd %edi ## encoding: [0xf3,0x0f,0xae,0xef]
; EGPR-NEXT:    retq ## encoding: [0xc3]
entry:
  tail call void @llvm.x86.incsspd(i32 %a)
  ret void
}

declare void @llvm.x86.incsspd(i32)

define void @test_incsspq(i32 %a) local_unnamed_addr {
; CHECK-LABEL: test_incsspq:
; CHECK:       ## %bb.0: ## %entry
; CHECK-NEXT:    movslq %edi, %rax ## encoding: [0x48,0x63,0xc7]
; CHECK-NEXT:    incsspq %rax ## encoding: [0xf3,0x48,0x0f,0xae,0xe8]
; CHECK-NEXT:    retq ## encoding: [0xc3]
;
; EGPR-LABEL: test_incsspq:
; EGPR:       ## %bb.0: ## %entry
; EGPR-NEXT:    movslq %edi, %rax ## encoding: [0x48,0x63,0xc7]
; EGPR-NEXT:    incsspq %rax ## encoding: [0xf3,0x48,0x0f,0xae,0xe8]
; EGPR-NEXT:    retq ## encoding: [0xc3]
entry:
  %conv.i = sext i32 %a to i64
  tail call void @llvm.x86.incsspq(i64 %conv.i)
  ret void
}

declare void @llvm.x86.incsspq(i64)

define i32 @test_rdsspd(i32 %a) {
; CHECK-LABEL: test_rdsspd:
; CHECK:       ## %bb.0: ## %entry
; CHECK-NEXT:    movl %edi, %eax ## encoding: [0x89,0xf8]
; CHECK-NEXT:    rdsspd %eax ## encoding: [0xf3,0x0f,0x1e,0xc8]
; CHECK-NEXT:    retq ## encoding: [0xc3]
;
; EGPR-LABEL: test_rdsspd:
; EGPR:       ## %bb.0: ## %entry
; EGPR-NEXT:    movl %edi, %eax ## encoding: [0x89,0xf8]
; EGPR-NEXT:    rdsspd %eax ## encoding: [0xf3,0x0f,0x1e,0xc8]
; EGPR-NEXT:    retq ## encoding: [0xc3]
entry:
  %0 = call i32 @llvm.x86.rdsspd(i32 %a)
  ret i32 %0
}

declare i32 @llvm.x86.rdsspd(i32)

define i64 @test_rdsspq(i64 %a) {
; CHECK-LABEL: test_rdsspq:
; CHECK:       ## %bb.0: ## %entry
; CHECK-NEXT:    movq %rdi, %rax ## encoding: [0x48,0x89,0xf8]
; CHECK-NEXT:    rdsspq %rax ## encoding: [0xf3,0x48,0x0f,0x1e,0xc8]
; CHECK-NEXT:    retq ## encoding: [0xc3]
;
; EGPR-LABEL: test_rdsspq:
; EGPR:       ## %bb.0: ## %entry
; EGPR-NEXT:    movq %rdi, %rax ## encoding: [0x48,0x89,0xf8]
; EGPR-NEXT:    rdsspq %rax ## encoding: [0xf3,0x48,0x0f,0x1e,0xc8]
; EGPR-NEXT:    retq ## encoding: [0xc3]
entry:
  %0 = call i64 @llvm.x86.rdsspq(i64 %a)
  ret i64 %0
}

declare i64 @llvm.x86.rdsspq(i64)

define void @test_saveprevssp() {
; CHECK-LABEL: test_saveprevssp:
; CHECK:       ## %bb.0: ## %entry
; CHECK-NEXT:    saveprevssp ## encoding: [0xf3,0x0f,0x01,0xea]
; CHECK-NEXT:    retq ## encoding: [0xc3]
;
; EGPR-LABEL: test_saveprevssp:
; EGPR:       ## %bb.0: ## %entry
; EGPR-NEXT:    saveprevssp ## encoding: [0xf3,0x0f,0x01,0xea]
; EGPR-NEXT:    retq ## encoding: [0xc3]
entry:
  tail call void @llvm.x86.saveprevssp()
  ret void
}

declare void @llvm.x86.saveprevssp()

define void @test_rstorssp(ptr %__p) {
; CHECK-LABEL: test_rstorssp:
; CHECK:       ## %bb.0: ## %entry
; CHECK-NEXT:    rstorssp (%rdi) ## encoding: [0xf3,0x0f,0x01,0x2f]
; CHECK-NEXT:    retq ## encoding: [0xc3]
;
; EGPR-LABEL: test_rstorssp:
; EGPR:       ## %bb.0: ## %entry
; EGPR-NEXT:    rstorssp (%rdi) ## encoding: [0xf3,0x0f,0x01,0x2f]
; EGPR-NEXT:    retq ## encoding: [0xc3]
entry:
  tail call void @llvm.x86.rstorssp(ptr %__p)
  ret void
}

declare void @llvm.x86.rstorssp(ptr)

define void @test_wrssd(i32 %a, ptr %__p) {
; CHECK-LABEL: test_wrssd:
; CHECK:       ## %bb.0: ## %entry
; CHECK-NEXT:    wrssd %edi, (%rsi) ## encoding: [0x0f,0x38,0xf6,0x3e]
; CHECK-NEXT:    retq ## encoding: [0xc3]
;
; EGPR-LABEL: test_wrssd:
; EGPR:       ## %bb.0: ## %entry
; EGPR-NEXT:    wrssd %edi, (%rsi) ## EVEX TO LEGACY Compression encoding: [0x0f,0x38,0xf6,0x3e]
; EGPR-NEXT:    retq ## encoding: [0xc3]
entry:
  tail call void @llvm.x86.wrssd(i32 %a, ptr %__p)
  ret void
}

declare void @llvm.x86.wrssd(i32, ptr)

define void @test_wrssq(i64 %a, ptr %__p) {
; CHECK-LABEL: test_wrssq:
; CHECK:       ## %bb.0: ## %entry
; CHECK-NEXT:    wrssq %rdi, (%rsi) ## encoding: [0x48,0x0f,0x38,0xf6,0x3e]
; CHECK-NEXT:    retq ## encoding: [0xc3]
;
; EGPR-LABEL: test_wrssq:
; EGPR:       ## %bb.0: ## %entry
; EGPR-NEXT:    wrssq %rdi, (%rsi) ## EVEX TO LEGACY Compression encoding: [0x48,0x0f,0x38,0xf6,0x3e]
; EGPR-NEXT:    retq ## encoding: [0xc3]
entry:
  tail call void @llvm.x86.wrssq(i64 %a, ptr %__p)
  ret void
}

declare void @llvm.x86.wrssq(i64, ptr)

define void @test_wrussd(i32 %a, ptr %__p) {
; CHECK-LABEL: test_wrussd:
; CHECK:       ## %bb.0: ## %entry
; CHECK-NEXT:    wrussd %edi, (%rsi) ## encoding: [0x66,0x0f,0x38,0xf5,0x3e]
; CHECK-NEXT:    retq ## encoding: [0xc3]
;
; EGPR-LABEL: test_wrussd:
; EGPR:       ## %bb.0: ## %entry
; EGPR-NEXT:    wrussd %edi, (%rsi) ## EVEX TO LEGACY Compression encoding: [0x66,0x0f,0x38,0xf5,0x3e]
; EGPR-NEXT:    retq ## encoding: [0xc3]
entry:
  tail call void @llvm.x86.wrussd(i32 %a, ptr %__p)
  ret void
}

declare void @llvm.x86.wrussd(i32, ptr)

define void @test_wrussq(i64 %a, ptr %__p) {
; CHECK-LABEL: test_wrussq:
; CHECK:       ## %bb.0: ## %entry
; CHECK-NEXT:    wrussq %rdi, (%rsi) ## encoding: [0x66,0x48,0x0f,0x38,0xf5,0x3e]
; CHECK-NEXT:    retq ## encoding: [0xc3]
;
; EGPR-LABEL: test_wrussq:
; EGPR:       ## %bb.0: ## %entry
; EGPR-NEXT:    wrussq %rdi, (%rsi) ## EVEX TO LEGACY Compression encoding: [0x66,0x48,0x0f,0x38,0xf5,0x3e]
; EGPR-NEXT:    retq ## encoding: [0xc3]
entry:
  tail call void @llvm.x86.wrussq(i64 %a, ptr %__p)
  ret void
}

declare void @llvm.x86.wrussq(i64, ptr)

define void @test_setssbsy() {
; CHECK-LABEL: test_setssbsy:
; CHECK:       ## %bb.0: ## %entry
; CHECK-NEXT:    setssbsy ## encoding: [0xf3,0x0f,0x01,0xe8]
; CHECK-NEXT:    retq ## encoding: [0xc3]
;
; EGPR-LABEL: test_setssbsy:
; EGPR:       ## %bb.0: ## %entry
; EGPR-NEXT:    setssbsy ## encoding: [0xf3,0x0f,0x01,0xe8]
; EGPR-NEXT:    retq ## encoding: [0xc3]
entry:
  tail call void @llvm.x86.setssbsy()
  ret void
}

declare void @llvm.x86.setssbsy()

define void @test_clrssbsy(ptr %__p) {
; CHECK-LABEL: test_clrssbsy:
; CHECK:       ## %bb.0: ## %entry
; CHECK-NEXT:    clrssbsy (%rdi) ## encoding: [0xf3,0x0f,0xae,0x37]
; CHECK-NEXT:    retq ## encoding: [0xc3]
;
; EGPR-LABEL: test_clrssbsy:
; EGPR:       ## %bb.0: ## %entry
; EGPR-NEXT:    clrssbsy (%rdi) ## encoding: [0xf3,0x0f,0xae,0x37]
; EGPR-NEXT:    retq ## encoding: [0xc3]
entry:
  tail call void @llvm.x86.clrssbsy(ptr %__p)
  ret void
}

declare void @llvm.x86.clrssbsy(ptr %__p)
