/* 
   change direct utf-8 strings in fontinfo.c, langfreq.c,
   sflayout.c, fontviewbase.c and metricsview.c
   into octal strings.
   original sources of fontinfo.c, langfreq.c,
   sflayout.c, fontviewbase.c and metricsview.c are
   fontinfo.c.src, langfreq.c.src,
   sflayout.c.src, fontviewbase.c.src and metricsview.c.src.
*/

#include <stdio.h>
#include <string.h>
int main(int argc, char **argv)
{
  FILE *fin, *fout;
  int c;          /* current character */
  int in = 0;     /* in a string */
  int inc = 0;    /* in comments */
  int inc2 = 0;   /* in comment  */
  int Prev = 0;   /* previous character */

  if(argc != 3) {
    fprintf(stderr, "to-octal input output\n");
    exit(0);
  }
  fin = fopen(argv[1], "rb");
  fout = fopen(argv[2], "wb");

  while ((c = fgetc(fin)) != EOF) {
    if(c == '"' && in == 0 && inc == 0 && inc2 == 0 && Prev != '\\') {
      fputc(c, fout);
      in = 1;
      Prev = c;
      continue;
    }
    else if(c == '\\' && in == 1 && inc == 0 && inc2 == 0 && Prev == '\\') {
      fputc(c, fout);
      Prev = 0;
      continue;
    }
    else if(c == '"' && in == 1 && inc == 0 && inc2 == 0 && Prev != '\\') {
      fputc(c, fout);
      in = 0;
      Prev = c;
      continue;
    }
    else if(c == '*' && in == 0 && inc == 0 && inc2 == 0 && Prev == '/') {
      fputc(c, fout);
      inc = 1;
      Prev = c;
      continue;
    }
    else if(c == '/' && in == 0 && inc == 1 && inc2 == 0 && Prev == '*') {
      fputc(c, fout);
      inc = 0;
      Prev = c;
      continue;
    }
    else if(c == '/' && in == 0 && inc == 0 && inc2 == 0 && Prev == '/') {
      fputc(c, fout);
      inc2 = 1;
      Prev = c;
      continue;
    }
    else if(c == '\r' && in == 0 && inc == 0 && inc2 == 1) {
      fputc(c, fout);
      inc2 = 0;
      Prev = c;
      continue;
    }
    else if(c == '\n' && in == 0 && inc == 0 && inc2 == 1) {
      fputc(c, fout);
      inc2 = 0;
      Prev = c;
      continue;
    }
    if(in == 0 && inc == 0 && inc2 == 0) {
      fputc(c, fout);
      Prev = c;
    }
    else {
      if((c >= 0x20 && c <= 0x7e) || c == '\r' || c == '\n')
	fputc(c, fout);
      else
	fprintf(fout, "\\%03o", c);
      Prev = c;
    }
  }
  fclose(fin);
  fclose(fout);
  return 0;
}
